/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.Charsets;
import com.google.common.collect.Ordering;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.db.meta.ArgumentMeta;
import org.nuiton.db.meta.ColumnMeta;
import org.nuiton.db.meta.CustomTypeMeta;
import org.nuiton.db.meta.DatabaseMeta;
import org.nuiton.db.meta.ProcedureMeta;
import org.nuiton.db.meta.TableMeta;

public class DatabaseMetaCommentExportHelper {
    private static final Log log = LogFactory.getLog(DatabaseMetaCommentExportHelper.class);
    private static final Ordering<TableMeta> TABLE_ORDERING = Ordering.natural().onResultOf(TableMeta::getName);
    private static final Ordering<ColumnMeta> COLUMN_ORDERING = Ordering.natural().onResultOf(ColumnMeta::getName);
    private static final Ordering<ProcedureMeta> PROCEDURE_ORDERING = Ordering.natural().onResultOf(ProcedureMeta::getName);
    private static final Ordering<CustomTypeMeta> CUSTOM_TYPE_ORDERING = Ordering.natural().onResultOf(CustomTypeMeta::getName);
    protected final String schemaPlaceholder;

    public DatabaseMetaCommentExportHelper(String schemaPlaceholder) {
        this.schemaPlaceholder = schemaPlaceholder;
    }

    public DatabaseMetaCommentExportHelper() {
        this("public");
    }

    public void exportCommentsToFile(DatabaseMeta databaseMeta, File file) {
        try {
            try (BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
                List<String> lines = this.asCommentLines(databaseMeta);
                for (String line : lines) {
                    writer.write(line);
                    writer.write("\n");
                }
                writer.flush();
            }
            log.debug((Object)("File wrote to " + file.getAbsolutePath()));
        }
        catch (Exception eee) {
            log.error((Object)"Unable to write file", (Throwable)eee);
        }
    }

    private List<String> asCommentLines(DatabaseMeta databaseMeta) {
        LinkedList<String> lines = new LinkedList<String>();
        TABLE_ORDERING.sortedCopy(databaseMeta.getTables()).forEach(table -> {
            lines.add(String.format("\n-- TABLE %s", table.getName()));
            List<String> tableLines = this.asCommentLines((TableMeta)table);
            lines.addAll(tableLines);
        });
        TABLE_ORDERING.sortedCopy(databaseMeta.getViews()).forEach(view -> {
            lines.add(String.format("\n-- VIEW %s", view.getName()));
            List<String> tableLines = this.asCommentLines((TableMeta)view);
            lines.addAll(tableLines);
        });
        PROCEDURE_ORDERING.sortedCopy(databaseMeta.getProcedures()).forEach(procedure -> {
            lines.add(String.format("\n-- FUNCTION %s", procedure.getName()));
            List<String> tableLines = this.asCommentLines((ProcedureMeta)procedure);
            lines.addAll(tableLines);
        });
        CUSTOM_TYPE_ORDERING.sortedCopy(databaseMeta.getCustomTypes()).forEach(customType -> {
            lines.add(String.format("\n-- TYPE %s", customType.getName()));
            List<String> tableLines = this.asCommentLines((CustomTypeMeta)customType);
            lines.addAll(tableLines);
        });
        return lines;
    }

    private List<String> asCommentLines(TableMeta tableMeta) {
        LinkedList<String> result = new LinkedList<String>();
        if (tableMeta.getComment().isPresent()) {
            String line = this.formatCommentLine(tableMeta.getName(), tableMeta.isView() ? CommentLineType.VIEW : CommentLineType.TABLE, null, tableMeta.getComment().get());
            result.add(line);
        }
        for (ColumnMeta column : COLUMN_ORDERING.sortedCopy(tableMeta.getColumns())) {
            Optional<String> columnLine = this.asCommentLine(tableMeta, column);
            columnLine.ifPresent(result::add);
        }
        return result;
    }

    private Optional<String> asCommentLine(TableMeta tableMeta, ColumnMeta columnMeta) {
        if (columnMeta.getComment().isPresent()) {
            String line = this.formatCommentLine(tableMeta.getName(), CommentLineType.COLUMN, columnMeta.getName(), columnMeta.getComment().get());
            return Optional.of(line);
        }
        return Optional.empty();
    }

    private List<String> asCommentLines(ProcedureMeta procedureMeta) {
        LinkedList<String> result = new LinkedList<String>();
        if (procedureMeta.getComment().isPresent()) {
            String argTypes = procedureMeta.getArgs().stream().map(ArgumentMeta::getType).collect(Collectors.joining(","));
            String procedureIdentifier = String.format("%s(%s)", procedureMeta.getName(), argTypes);
            String line = this.formatCommentLine(procedureIdentifier, CommentLineType.FUNCTION, null, procedureMeta.getComment().get());
            result.add(line);
        }
        return result;
    }

    private List<String> asCommentLines(CustomTypeMeta customTypeMeta) {
        LinkedList<String> result = new LinkedList<String>();
        if (customTypeMeta.getComment().isPresent()) {
            String line = this.formatCommentLine(customTypeMeta.getName(), CommentLineType.TYPE, null, customTypeMeta.getComment().get());
            result.add(line);
        }
        return result;
    }

    private String formatCommentLine(String table, CommentLineType type, String colonne, String commentaire) {
        String escaped = commentaire.replaceAll("'", "''");
        String result = StringUtils.isEmpty((CharSequence)colonne) && CommentLineType.VIEW.equals((Object)type) ? String.format("COMMENT ON VIEW %s.%s IS '%s';", this.schemaPlaceholder, table, escaped) : (StringUtils.isEmpty((CharSequence)colonne) && CommentLineType.FUNCTION.equals((Object)type) ? String.format("COMMENT ON FUNCTION %s.%s IS '%s';", this.schemaPlaceholder, table, escaped) : (StringUtils.isEmpty((CharSequence)colonne) && CommentLineType.TYPE.equals((Object)type) ? String.format("COMMENT ON TYPE %s.%s IS '%s';", this.schemaPlaceholder, table, escaped) : (StringUtils.isEmpty((CharSequence)colonne) ? String.format("COMMENT ON TABLE %s.%s IS '%s';", this.schemaPlaceholder, table, escaped) : String.format("COMMENT ON COLUMN %s.%s.%s IS '%s';", this.schemaPlaceholder, table, colonne, escaped))));
        return result;
    }

    private static enum CommentLineType {
        VIEW,
        FUNCTION,
        TABLE,
        COLUMN,
        TYPE;

    }
}

