/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.immutables.value.Value;
import org.nuiton.db.meta.CustomTypeMeta;
import org.nuiton.db.meta.ProcedureMeta;
import org.nuiton.db.meta.TableMeta;

@Value.Immutable
public interface DatabaseMeta {
    public String getSchema();

    public ImmutableList<CustomTypeMeta> getCustomTypes();

    default public Optional<CustomTypeMeta> findCustomType(String name) {
        Optional<CustomTypeMeta> result = this.getCustomTypes().stream().filter(type -> type.getName().equals(name)).findAny();
        return result;
    }

    public ImmutableList<TableMeta> getTables();

    default public Optional<TableMeta> findTable(String name) {
        Optional<TableMeta> result = this.getTables().stream().filter(table -> table.getName().equals(name)).findAny();
        return result;
    }

    public ImmutableList<TableMeta> getViews();

    public ImmutableList<ProcedureMeta> getProcedures();
}

