/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.nuiton.db.meta.ColumnMeta;
import org.nuiton.db.meta.TableMeta;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TableMeta", generator="Immutables")
@Immutable
public final class ImmutableTableMeta
implements TableMeta {
    private final String name;
    private final boolean isView;
    private final ImmutableList<ColumnMeta> columns;
    @Nullable
    private final Long count;
    @Nullable
    private final String comment;

    private ImmutableTableMeta(String name, boolean isView, ImmutableList<ColumnMeta> columns, @Nullable Long count, @Nullable String comment) {
        this.name = name;
        this.isView = isView;
        this.columns = columns;
        this.count = count;
        this.comment = comment;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isView() {
        return this.isView;
    }

    @Override
    public ImmutableList<ColumnMeta> getColumns() {
        return this.columns;
    }

    @Override
    public Optional<Long> getCount() {
        return Optional.ofNullable(this.count);
    }

    @Override
    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public final ImmutableTableMeta withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTableMeta(newValue, this.isView, this.columns, this.count, this.comment);
    }

    public final ImmutableTableMeta withIsView(boolean value) {
        if (this.isView == value) {
            return this;
        }
        return new ImmutableTableMeta(this.name, value, this.columns, this.count, this.comment);
    }

    public final ImmutableTableMeta withColumns(ColumnMeta ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTableMeta(this.name, this.isView, (ImmutableList<ColumnMeta>)newValue, this.count, this.comment);
    }

    public final ImmutableTableMeta withColumns(Iterable<? extends ColumnMeta> elements) {
        if (this.columns == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTableMeta(this.name, this.isView, (ImmutableList<ColumnMeta>)newValue, this.count, this.comment);
    }

    public final ImmutableTableMeta withCount(long value) {
        Long newValue = value;
        if (Objects.equals(this.count, newValue)) {
            return this;
        }
        return new ImmutableTableMeta(this.name, this.isView, this.columns, newValue, this.comment);
    }

    public final ImmutableTableMeta withCount(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return new ImmutableTableMeta(this.name, this.isView, this.columns, value, this.comment);
    }

    public final ImmutableTableMeta withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (Objects.equals(this.comment, newValue)) {
            return this;
        }
        return new ImmutableTableMeta(this.name, this.isView, this.columns, this.count, newValue);
    }

    public final ImmutableTableMeta withComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return new ImmutableTableMeta(this.name, this.isView, this.columns, this.count, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTableMeta && this.equalTo((ImmutableTableMeta)another);
    }

    private boolean equalTo(ImmutableTableMeta another) {
        return this.name.equals(another.name) && this.isView == another.isView && this.columns.equals(another.columns) && Objects.equals(this.count, another.count) && Objects.equals(this.comment, another.comment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isView);
        h += (h << 5) + this.columns.hashCode();
        h += (h << 5) + Objects.hashCode(this.count);
        h += (h << 5) + Objects.hashCode(this.comment);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TableMeta").omitNullValues().add("name", (Object)this.name).add("isView", this.isView).add("columns", this.columns).add("count", (Object)this.count).add("comment", (Object)this.comment).toString();
    }

    public static ImmutableTableMeta copyOf(TableMeta instance) {
        if (instance instanceof ImmutableTableMeta) {
            return (ImmutableTableMeta)instance;
        }
        return ImmutableTableMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TableMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_IS_VIEW = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        private boolean isView;
        private ImmutableList.Builder<ColumnMeta> columns = ImmutableList.builder();
        @Nullable
        private Long count;
        @Nullable
        private String comment;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TableMeta instance) {
            Optional<String> commentOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.isView(instance.isView());
            this.addAllColumns((Iterable<? extends ColumnMeta>)instance.getColumns());
            Optional<Long> countOptional = instance.getCount();
            if (countOptional.isPresent()) {
                this.count(countOptional);
            }
            if ((commentOptional = instance.getComment()).isPresent()) {
                this.comment(commentOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isView(boolean isView) {
            this.isView = isView;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(ColumnMeta element) {
            this.columns.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addColumns(ColumnMeta ... elements) {
            this.columns.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder columns(Iterable<? extends ColumnMeta> elements) {
            this.columns = ImmutableList.builder();
            return this.addAllColumns(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllColumns(Iterable<? extends ColumnMeta> elements) {
            this.columns.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(long count) {
            this.count = count;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder count(Optional<Long> count) {
            this.count = count.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(Optional<String> comment) {
            this.comment = comment.orElse(null);
            return this;
        }

        public ImmutableTableMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTableMeta(this.name, this.isView, this.columns.build(), this.count, this.comment);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isView");
            }
            return "Cannot build TableMeta, some of required attributes are not set " + attributes;
        }
    }
}

