/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.db.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.nuiton.db.meta.ColumnMeta;
import org.nuiton.db.meta.CustomTypeMeta;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ColumnMeta", generator="Immutables")
@Immutable
public final class ImmutableColumnMeta
implements ColumnMeta {
    private final String name;
    private final String type;
    @Nullable
    private final CustomTypeMeta customType;
    @Nullable
    private final Integer length;
    private final boolean nullable;
    @Nullable
    private final String comment;
    private final boolean isPrimaryKey;
    private final boolean isUnique;
    private final boolean isForeignKey;
    private final ImmutableSet<String> foreignKeyColumns;
    @Nullable
    private final Map<String, String> possibleValues;

    private ImmutableColumnMeta(String name, String type, @Nullable CustomTypeMeta customType, @Nullable Integer length, boolean nullable, @Nullable String comment, boolean isPrimaryKey, boolean isUnique, boolean isForeignKey, ImmutableSet<String> foreignKeyColumns, @Nullable Map<String, String> possibleValues) {
        this.name = name;
        this.type = type;
        this.customType = customType;
        this.length = length;
        this.nullable = nullable;
        this.comment = comment;
        this.isPrimaryKey = isPrimaryKey;
        this.isUnique = isUnique;
        this.isForeignKey = isForeignKey;
        this.foreignKeyColumns = foreignKeyColumns;
        this.possibleValues = possibleValues;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Optional<CustomTypeMeta> getCustomType() {
        return Optional.ofNullable(this.customType);
    }

    @Override
    public Optional<Integer> getLength() {
        return Optional.ofNullable(this.length);
    }

    @Override
    public boolean getNullable() {
        return this.nullable;
    }

    @Override
    public Optional<String> getComment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    @Override
    public ImmutableSet<String> getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    @Override
    public Optional<Map<String, String>> getPossibleValues() {
        return Optional.ofNullable(this.possibleValues);
    }

    public final ImmutableColumnMeta withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableColumnMeta(newValue, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, newValue, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withCustomType(CustomTypeMeta value) {
        CustomTypeMeta newValue = Objects.requireNonNull(value, "customType");
        if (this.customType == newValue) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, newValue, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withCustomType(Optional<? extends CustomTypeMeta> optional) {
        CustomTypeMeta value = optional.orElse(null);
        if (this.customType == value) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, value, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withLength(int value) {
        Integer newValue = value;
        if (Objects.equals(this.length, newValue)) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, newValue, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.length, value)) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, value, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withNullable(boolean value) {
        if (this.nullable == value) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, value, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withComment(String value) {
        String newValue = Objects.requireNonNull(value, "comment");
        if (Objects.equals(this.comment, newValue)) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, newValue, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.comment, value)) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, value, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withIsPrimaryKey(boolean value) {
        if (this.isPrimaryKey == value) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, value, this.isUnique, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withIsUnique(boolean value) {
        if (this.isUnique == value) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, value, this.isForeignKey, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withIsForeignKey(boolean value) {
        if (this.isForeignKey == value) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, value, this.foreignKeyColumns, this.possibleValues);
    }

    public final ImmutableColumnMeta withForeignKeyColumns(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, (ImmutableSet<String>)newValue, this.possibleValues);
    }

    public final ImmutableColumnMeta withForeignKeyColumns(Iterable<String> elements) {
        if (this.foreignKeyColumns == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, (ImmutableSet<String>)newValue, this.possibleValues);
    }

    public final ImmutableColumnMeta withPossibleValues(Map<String, String> value) {
        Map<String, String> newValue = Objects.requireNonNull(value, "possibleValues");
        if (this.possibleValues == newValue) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, newValue);
    }

    public final ImmutableColumnMeta withPossibleValues(Optional<? extends Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.possibleValues == value) {
            return this;
        }
        return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableColumnMeta && this.equalTo((ImmutableColumnMeta)another);
    }

    private boolean equalTo(ImmutableColumnMeta another) {
        return this.name.equals(another.name) && this.type.equals(another.type) && Objects.equals(this.customType, another.customType) && Objects.equals(this.length, another.length) && this.nullable == another.nullable && Objects.equals(this.comment, another.comment) && this.isPrimaryKey == another.isPrimaryKey && this.isUnique == another.isUnique && this.isForeignKey == another.isForeignKey && this.foreignKeyColumns.equals(another.foreignKeyColumns) && Objects.equals(this.possibleValues, another.possibleValues);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.customType);
        h += (h << 5) + Objects.hashCode(this.length);
        h += (h << 5) + Booleans.hashCode((boolean)this.nullable);
        h += (h << 5) + Objects.hashCode(this.comment);
        h += (h << 5) + Booleans.hashCode((boolean)this.isPrimaryKey);
        h += (h << 5) + Booleans.hashCode((boolean)this.isUnique);
        h += (h << 5) + Booleans.hashCode((boolean)this.isForeignKey);
        h += (h << 5) + this.foreignKeyColumns.hashCode();
        h += (h << 5) + Objects.hashCode(this.possibleValues);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ColumnMeta").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("customType", (Object)this.customType).add("length", (Object)this.length).add("nullable", this.nullable).add("comment", (Object)this.comment).add("isPrimaryKey", this.isPrimaryKey).add("isUnique", this.isUnique).add("isForeignKey", this.isForeignKey).add("foreignKeyColumns", this.foreignKeyColumns).add("possibleValues", this.possibleValues).toString();
    }

    public static ImmutableColumnMeta copyOf(ColumnMeta instance) {
        if (instance instanceof ImmutableColumnMeta) {
            return (ImmutableColumnMeta)instance;
        }
        return ImmutableColumnMeta.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ColumnMeta", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_NULLABLE = 4L;
        private static final long INIT_BIT_IS_PRIMARY_KEY = 8L;
        private static final long INIT_BIT_IS_UNIQUE = 16L;
        private static final long INIT_BIT_IS_FOREIGN_KEY = 32L;
        private long initBits = 63L;
        @Nullable
        private String name;
        @Nullable
        private String type;
        @Nullable
        private CustomTypeMeta customType;
        @Nullable
        private Integer length;
        private boolean nullable;
        @Nullable
        private String comment;
        private boolean isPrimaryKey;
        private boolean isUnique;
        private boolean isForeignKey;
        private ImmutableSet.Builder<String> foreignKeyColumns = ImmutableSet.builder();
        @Nullable
        private Map<String, String> possibleValues;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ColumnMeta instance) {
            Optional<Integer> lengthOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.type(instance.getType());
            Optional<CustomTypeMeta> customTypeOptional = instance.getCustomType();
            if (customTypeOptional.isPresent()) {
                this.customType(customTypeOptional);
            }
            if ((lengthOptional = instance.getLength()).isPresent()) {
                this.length(lengthOptional);
            }
            this.nullable(instance.getNullable());
            Optional<String> commentOptional = instance.getComment();
            if (commentOptional.isPresent()) {
                this.comment(commentOptional);
            }
            this.isPrimaryKey(instance.isPrimaryKey());
            this.isUnique(instance.isUnique());
            this.isForeignKey(instance.isForeignKey());
            this.addAllForeignKeyColumns((Iterable<String>)instance.getForeignKeyColumns());
            Optional<Map<String, String>> possibleValuesOptional = instance.getPossibleValues();
            if (possibleValuesOptional.isPresent()) {
                this.possibleValues(possibleValuesOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customType(CustomTypeMeta customType) {
            this.customType = Objects.requireNonNull(customType, "customType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder customType(Optional<? extends CustomTypeMeta> customType) {
            this.customType = customType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder length(int length) {
            this.length = length;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder length(Optional<Integer> length) {
            this.length = length.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullable(boolean nullable) {
            this.nullable = nullable;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment, "comment");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comment(Optional<String> comment) {
            this.comment = comment.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isPrimaryKey(boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isUnique(boolean isUnique) {
            this.isUnique = isUnique;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isForeignKey(boolean isForeignKey) {
            this.isForeignKey = isForeignKey;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addForeignKeyColumns(String element) {
            this.foreignKeyColumns.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addForeignKeyColumns(String ... elements) {
            this.foreignKeyColumns.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder foreignKeyColumns(Iterable<String> elements) {
            this.foreignKeyColumns = ImmutableSet.builder();
            return this.addAllForeignKeyColumns(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllForeignKeyColumns(Iterable<String> elements) {
            this.foreignKeyColumns.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder possibleValues(Map<String, String> possibleValues) {
            this.possibleValues = Objects.requireNonNull(possibleValues, "possibleValues");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder possibleValues(Optional<? extends Map<String, String>> possibleValues) {
            this.possibleValues = possibleValues.orElse(null);
            return this;
        }

        public ImmutableColumnMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableColumnMeta(this.name, this.type, this.customType, this.length, this.nullable, this.comment, this.isPrimaryKey, this.isUnique, this.isForeignKey, this.foreignKeyColumns.build(), this.possibleValues);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nullable");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isPrimaryKey");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("isUnique");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("isForeignKey");
            }
            return "Cannot build ColumnMeta, some of required attributes are not set " + attributes;
        }
    }
}

