/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.csv;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.nuiton.csv.Column;
import org.nuiton.csv.Common;
import org.nuiton.csv.ExportableColumn;
import org.nuiton.csv.Exporter;
import org.nuiton.csv.ExporterConfiguration;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueGetter;

public class ExporterBuilder<O> {
    public static final String DEFAULT_CELL_SEPARATOR = ";";
    public static final String DEFAULT_END_OF_LINE_SEPARATOR = "\n";
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    protected final ExporterConfiguration<O> configuration;
    protected final ImmutableSet.Builder<ExportableColumn<O, ?>> columnsBuilder = ImmutableSet.builder();

    public ExporterBuilder<O> setCellSeparator(String cellSeparator) {
        this.configuration.setCellSeparator(cellSeparator);
        return this;
    }

    public ExporterBuilder<O> setEndOfLineSeparator(String endOfLineSeparator) {
        this.configuration.setEndOfLineSeparator(endOfLineSeparator);
        return this;
    }

    public ExporterBuilder<O> setCharset(Charset charset) {
        this.configuration.setCharset(charset);
        return this;
    }

    public ExporterBuilder<O> addColumns(Iterable<ExportableColumn<O, Object>> columns) {
        this.columnsBuilder.addAll(columns);
        return this;
    }

    public ExporterBuilder<O> addColumn(String propertyName) {
        return this.addColumn(propertyName, propertyName, Common.STRING);
    }

    public ExporterBuilder<O> addColumn(String headerName, String propertyName) {
        return this.addColumn(headerName, propertyName, Common.STRING);
    }

    public ExporterBuilder<O> addColumn(String headerName, ValueGetter<O, String> valueGetter) {
        return this.addColumn(headerName, valueGetter, Common.STRING);
    }

    public <T> ExporterBuilder<O> addColumn(String headerName, String propertyName, ValueFormatter<T> valueFormatter) {
        return this.addColumn(headerName, new Common.BeanProperty(propertyName), valueFormatter);
    }

    public <T> ExporterBuilder<O> addColumn(String headerName, ValueGetter<O, T> valueGetter, ValueFormatter<T> valueFormatter) {
        Column<O, T> newColumn = Column.newExportableColumn(headerName, valueGetter, valueFormatter, false);
        this.columnsBuilder.add(newColumn);
        return this;
    }

    public Exporter<O> build() {
        this.configuration.setColumns(this.columnsBuilder.build());
        Preconditions.checkNotNull(this.configuration.getColumns(), (Object)"No columns defined.");
        Preconditions.checkNotNull((Object)this.configuration.getCellSeparator(), (Object)"No charset defined.");
        Preconditions.checkNotNull((Object)this.configuration.getCellSeparator(), (Object)"No cellSeparator defined.");
        Preconditions.checkNotNull((Object)this.configuration.getEndOfLineSeparator(), (Object)"No endOfLineSeparator defined.");
        return new Exporter<O>(this.configuration);
    }

    public ExporterBuilder() {
        this.configuration = new ExporterConfiguration();
        this.setCharset(DEFAULT_CHARSET);
        this.setCellSeparator(DEFAULT_CELL_SEPARATOR);
        this.setEndOfLineSeparator(DEFAULT_END_OF_LINE_SEPARATOR);
    }

    public ExporterBuilder(ExporterConfiguration<O> configuration) {
        this.configuration = new ExporterConfiguration();
        this.addColumns((Iterable<ExportableColumn<O, Object>>)configuration.getColumns());
        this.setCharset(configuration.getCharset());
        this.setCellSeparator(configuration.getCellSeparator());
        this.setEndOfLineSeparator(configuration.getEndOfLineSeparator());
    }
}

