package org.nuiton.util.csv.ext;
/*
 * #%L
 * Nuiton Utils :: Nuiton Csv
 * $Id: AbstractImportModel.java 2400 2012-08-16 15:19:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-utils/tags/nuiton-utils-2.6.11/nuiton-csv/src/main/java/org/nuiton/util/csv/ext/AbstractImportModel.java $
 * %%
 * Copyright (C) 2011 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportableColumn;
import org.nuiton.util.csv.ModelBuilder;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ValueSetter;

import java.util.List;

/**
 * Abstract implementation of a {@link ImportModel} to avoid all the
 * boilerplate code when creating a new model.
 *
 * @param <E> type of object to import
 * @author tchemit <chemit@codelutin.com>
 * @since 2.6
 */
public abstract class AbstractImportModel<E> implements ImportModel<E> {

    private final char separator;

    protected final ModelBuilder<E> modelBuilder;

    public AbstractImportModel(char separator) {
        this.separator = separator;
        modelBuilder = new ModelBuilder<E>();
    }

    @Override
    public final char getSeparator() {
        return separator;
    }

    @Override
    public void pushCsvHeaderNames(List<String> headerNames) {
    }

    @Override
    public final Iterable<ImportableColumn<E, Object>> getColumnsForImport() {
        return (Iterable) modelBuilder.getColumnsForImport();
    }

    public <T> ImportableColumn<E, T> newIgnoredColumn(String headerName) {
        return modelBuilder.newIgnoredColumn(headerName);
    }

    public ImportableColumn<E, String> newMandatoryColumn(String headerName) {
        return modelBuilder.newMandatoryColumn(headerName, headerName);
    }

    public ImportableColumn<E, String> newMandatoryColumn(String headerName, String propertyName) {
        return modelBuilder.newMandatoryColumn(headerName, propertyName);
    }

    public <T> ImportableColumn<E, T> newMandatoryColumn(String headerName, ValueParser<T> valueParser) {
        return modelBuilder.newMandatoryColumn(headerName, headerName, valueParser);
    }

    public <T> ImportableColumn<E, T> newMandatoryColumn(String headerName, String propertyName, ValueParser<T> valueParser) {
        return modelBuilder.newMandatoryColumn(headerName, propertyName, valueParser);
    }

    public ImportableColumn<E, String> newMandatoryColumn(String headerName, ValueSetter<E, String> eStringValueSetter) {
        return modelBuilder.newMandatoryColumn(headerName, eStringValueSetter);
    }

    public <T> ImportableColumn<E, T> newMandatoryColumn(String headerName, ValueParser<T> valueParser, ValueSetter<E, T> etValueSetter) {
        return modelBuilder.newMandatoryColumn(headerName, valueParser, etValueSetter);
    }

}