/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.csv.Import;
import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportRuntimeException;
import org.nuiton.util.csv.ImportableColumn;

public class ImportToMap
extends Import<Map<String, Object>> {
    private static final Log log = LogFactory.getLog(ImportToMap.class);

    public static ImportToMap newImport(ImportModel<Map<String, Object>> model, InputStream inputStream) {
        return new ImportToMap(model, inputStream);
    }

    public static ImportToMap newImport(ImportModel<Map<String, Object>> model, Reader reader) {
        return new ImportToMap(model, reader);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.prepareAndValidate();
        this.readFirstLine();
        return new Iterator<Map<String, Object>>(){
            boolean hasNext = true;
            int lineNumber;
            Map<String, Object> element = new HashMap<String, Object>();

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Map<String, Object> next() throws NoSuchElementException, ImportRuntimeException {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                ++this.lineNumber;
                this.element.clear();
                for (ImportableColumn<Map<String, Object>, Object> importableColumn : ImportToMap.this.getNonIgnoredHeaders()) {
                    Object parsedValue;
                    String value;
                    try {
                        value = ImportToMap.this.reader.get(importableColumn.getHeaderName());
                    }
                    catch (Exception e) {
                        ImportToMap.this.reader.close();
                        throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadField", (Object[])new Object[]{importableColumn.getHeaderName(), this.lineNumber}), e);
                    }
                    try {
                        parsedValue = importableColumn.parseValue(value);
                    }
                    catch (Exception e) {
                        String message = I18n._((String)"csv.import.error.unableToParseValue", (Object[])new Object[]{value, importableColumn.getHeaderName(), this.lineNumber}) + "\n" + e.getMessage();
                        throw new ImportRuntimeException(message, e);
                    }
                    try {
                        importableColumn.setValue(this.element, parsedValue);
                    }
                    catch (Exception e) {
                        String message = I18n._((String)"csv.import.error.unableToSetValue", (Object[])new Object[]{parsedValue, this.element.toString(), this.lineNumber, importableColumn.getHeaderName()});
                        if (log.isErrorEnabled()) {
                            log.error((Object)message);
                        }
                        throw new ImportRuntimeException(message, e);
                    }
                }
                try {
                    this.hasNext = ImportToMap.this.reader.readRecord();
                }
                catch (IOException e) {
                    ImportToMap.this.reader.close();
                    throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadLine", (Object[])new Object[]{this.lineNumber + 1}), e);
                }
                return this.element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, InputStream inputStream) {
        super(mapImportModel, inputStream);
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, Reader reader) {
        super(mapImportModel, reader);
    }
}

