/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import com.csvreader.CsvReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportRuntimeException;
import org.nuiton.util.csv.ImportableColumn;

public class Import<E>
implements Iterable<E>,
Closeable {
    private static final Log log = LogFactory.getLog(Import.class);
    protected ImportModel<E> model;
    protected CsvReader reader;
    protected boolean validate;

    public static <E> Import<E> newImport(ImportModel<E> model, InputStream inputStream) {
        return new Import<E>(model, inputStream);
    }

    public static <E> Import<E> newImport(ImportModel<E> model, Reader reader) {
        return new Import<E>(model, reader);
    }

    @Override
    public Iterator<E> iterator() {
        this.prepareAndValidate();
        this.readFirstLine();
        return new Iterator<E>(){
            boolean hasNext = true;
            int lineNumber;
            E lastElement;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() throws NoSuchElementException, ImportRuntimeException {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                ++this.lineNumber;
                Object element = Import.this.model.newEmptyInstance();
                for (ImportableColumn field : Import.this.getNonIgnoredHeaders()) {
                    Object parsedValue;
                    String value;
                    try {
                        value = Import.this.reader.get(field.getHeaderName());
                    }
                    catch (Exception e) {
                        Import.this.reader.close();
                        throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadField", (Object[])new Object[]{field.getHeaderName(), this.lineNumber}), e);
                    }
                    try {
                        parsedValue = field.parseValue(value);
                    }
                    catch (Exception e) {
                        String message = I18n._((String)"csv.import.error.unableToParseValue", (Object[])new Object[]{value, field.getHeaderName(), this.lineNumber}) + "\n" + e.getMessage();
                        throw new ImportRuntimeException(message, e);
                    }
                    try {
                        field.setValue(element, parsedValue);
                    }
                    catch (Exception e) {
                        String message = I18n._((String)"csv.import.error.unableToSetValue", (Object[])new Object[]{parsedValue, element.toString(), this.lineNumber, field.getHeaderName()});
                        if (log.isErrorEnabled()) {
                            log.error((Object)message);
                        }
                        throw new ImportRuntimeException(message, e);
                    }
                    this.lastElement = element;
                }
                try {
                    this.hasNext = Import.this.reader.readRecord();
                }
                catch (IOException e) {
                    Import.this.reader.close();
                    throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadLine", (Object[])new Object[]{this.lineNumber + 1}), e);
                }
                return this.lastElement;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() {
        this.reader.close();
    }

    public void prepareAndValidate() {
        if (this.validate) {
            return;
        }
        this.validate = true;
        Object[] headers = this.getHeaders();
        if (log.isTraceEnabled()) {
            log.trace((Object)("headers of the CSV file are : " + Arrays.toString(headers)));
        }
        this.model.pushCsvHeaderNames(Arrays.asList(headers));
        this.checkUniqueModelColumnNames();
        this.checkHeaderNamesAreAllKnown((String[])headers);
        this.checkAllManadatoryHeadersArePresent((String[])headers);
    }

    protected void checkHeaderNamesAreAllKnown(String[] headers) {
        ArrayList csvHeaders = new ArrayList();
        Collections.addAll(csvHeaders, headers);
        for (ImportableColumn<E, Object> field : this.model.getColumnsForImport()) {
            csvHeaders.remove(field.getHeaderName());
        }
        if (!csvHeaders.isEmpty()) {
            LinkedList<String> validHeaderNames = new LinkedList<String>();
            for (ImportableColumn<E, Object> importableColumn : this.model.getColumnsForImport()) {
                validHeaderNames.add(importableColumn.getHeaderName());
            }
            String validationMessage = I18n._((String)"csv.import.error.unrecognizedHeaders", (Object[])new Object[]{StringUtil.join(csvHeaders, (String)", ", (boolean)true), StringUtil.join(validHeaderNames, (String)", ", (boolean)true)});
            throw new ImportRuntimeException(validationMessage);
        }
    }

    protected void checkUniqueModelColumnNames() {
        HashSet<String> headerNames = new HashSet<String>();
        HashSet<String> doubleHeaderNames = new HashSet<String>();
        for (ImportableColumn<E, Object> importableColumn : this.model.getColumnsForImport()) {
            String headerName = importableColumn.getHeaderName();
            boolean alreadyUsed = !headerNames.add(headerName);
            if (!alreadyUsed) continue;
            doubleHeaderNames.add(headerName);
        }
        if (!doubleHeaderNames.isEmpty()) {
            String message = I18n._((String)"csv.import.error.duplicatedHeaders", (Object[])new Object[]{StringUtil.join(doubleHeaderNames, (String)", ", (boolean)true)});
            throw new ImportRuntimeException(message);
        }
    }

    protected void checkAllManadatoryHeadersArePresent(String[] headers) {
        ArrayList csvHeaders = new ArrayList();
        Collections.addAll(csvHeaders, headers);
        ArrayList<String> mandatoryHeadersNames = new ArrayList<String>();
        for (ImportableColumn<E, ?> field : this.getAllMandatoryHeaders()) {
            mandatoryHeadersNames.add(field.getHeaderName());
        }
        mandatoryHeadersNames.removeAll(csvHeaders);
        if (!mandatoryHeadersNames.isEmpty()) {
            String validationMessage = I18n._((String)"csv.import.error.missingMandatoryHeaders", (Object[])new Object[]{StringUtil.join(mandatoryHeadersNames, (String)", ", (boolean)true)});
            throw new ImportRuntimeException(validationMessage);
        }
        HashSet<String> headerNames = new HashSet<String>();
        for (ImportableColumn<E, Object> importableColumn : this.model.getColumnsForImport()) {
            String headerName = importableColumn.getHeaderName();
            boolean alreadyUsed = !headerNames.add(headerName);
            if (!alreadyUsed) continue;
            throw new ImportRuntimeException("model contains multiple columnsForImport named '" + headerName + "'");
        }
    }

    protected String[] getHeaders() throws ImportRuntimeException {
        try {
            boolean canReadHeaders = this.reader.readHeaders();
            if (!canReadHeaders) {
                throw new ImportRuntimeException("can't read headers");
            }
        }
        catch (IOException e) {
            throw new ImportRuntimeException("can't read headers");
        }
        try {
            String[] result = this.reader.getHeaders();
            return result;
        }
        catch (IOException eee) {
            throw new ImportRuntimeException("can't get headers", eee);
        }
    }

    protected List<ImportableColumn<E, Object>> getNonIgnoredHeaders() {
        ArrayList<ImportableColumn<ImportableColumn<E, Object>, Object>> nonIgnoredHeaders = new ArrayList<ImportableColumn<ImportableColumn<E, Object>, Object>>();
        for (ImportableColumn<E, Object> field : this.model.getColumnsForImport()) {
            if (field.isIgnored()) continue;
            nonIgnoredHeaders.add(field);
        }
        return nonIgnoredHeaders;
    }

    protected List<ImportableColumn<E, ?>> getAllMandatoryHeaders() {
        ArrayList allMandatoryHeaders = new ArrayList();
        for (ImportableColumn<E, Object> field : this.model.getColumnsForImport()) {
            if (!field.isMandatory()) continue;
            allMandatoryHeaders.add(field);
        }
        return allMandatoryHeaders;
    }

    protected Import(ImportModel<E> model, InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        this.model = model;
        this.reader = new CsvReader(inputStream, model.getSeparator(), Charset.forName("UTF-8"));
        this.reader.setTrimWhitespace(true);
    }

    protected Import(ImportModel<E> model, Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        this.model = model;
        this.reader = new CsvReader(reader, model.getSeparator());
        this.reader.setTrimWhitespace(true);
    }

    protected void readFirstLine() throws ImportRuntimeException {
        try {
            boolean emptyFile;
            boolean bl = emptyFile = !this.reader.readRecord();
            if (emptyFile) {
                throw new ImportRuntimeException("CSV file has no line");
            }
        }
        catch (IOException e) {
            this.reader.close();
            throw new ImportRuntimeException(I18n._((String)"csv.import.error.unableToReadLine", (Object[])new Object[]{1}), e);
        }
    }
}

