/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;

public class Export<E> {
    private static final Log log = LogFactory.getLog(Export.class);
    protected ExportModel<E> model;
    protected Iterable<E> data;

    public static <E> Export<E> newExport(ExportModel<E> model, Iterable<E> data) {
        return new Export<E>(model, data);
    }

    public static <E> void exportToWriter(ExportModel<E> model, Iterable<E> data, Writer writer) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.write(writer);
    }

    public static <E> void exportToFile(ExportModel<E> model, Iterable<E> data, File file) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.write(file);
    }

    public static <E> void exportToFile(ExportModel<E> model, Iterable<E> data, File file, Charset charset) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        exporter.write(file, charset);
    }

    public static <E> String exportToString(ExportModel<E> model, Iterable<E> data) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        return exporter.toString(Charset.defaultCharset());
    }

    public static <E> String exportToString(ExportModel<E> model, Iterable<E> data, Charset charset) throws Exception {
        Export<E> exporter = Export.newExport(model, data);
        return exporter.toString(charset);
    }

    protected Export(ExportModel<E> model, Iterable<E> data) {
        this.model = model;
        this.data = data;
    }

    public void write(Writer writer) throws Exception {
        String separator = String.valueOf(this.model.getSeparator());
        LinkedList<String> headerNames = new LinkedList<String>();
        for (ExportableColumn<E, Object> column : this.model.getColumnsForExport()) {
            headerNames.add(column.getHeaderName());
        }
        String headersLine = StringUtil.join(headerNames, (String)separator, (boolean)true);
        writer.write(headersLine);
        writer.write(10);
        if (log.isDebugEnabled()) {
            log.debug((Object)("headers for export are '" + headersLine + "'"));
            if (this.data instanceof Collection) {
                log.debug((Object)("will export " + ((Collection)this.data).size() + " lines"));
            }
        }
        Iterable<ExportableColumn<E, Object>> columnsForExport = this.model.getColumnsForExport();
        for (E object : this.data) {
            for (ExportableColumn<E, Object> column : columnsForExport) {
                Object value;
                String formattedValue = column.formatValue(value = column.getValue(object));
                if (formattedValue == null) {
                    throw new NullPointerException("column for header " + column.getHeaderName() + " returned a null value." + column.toString());
                }
                formattedValue = StringUtil.escapeCsvValue((String)formattedValue, (String)separator);
                writer.write(formattedValue);
                writer.write(separator);
            }
            writer.write(10);
        }
    }

    public void write(OutputStream outputStream, Charset charset) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        this.write(writer);
    }

    public void write(OutputStream outputStream) throws Exception {
        this.write(outputStream, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Charset charset) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.write(fileOutputStream, charset);
        }
        finally {
            fileOutputStream.close();
        }
    }

    public void write(File file) throws Exception {
        this.write(file, Charset.defaultCharset());
    }

    public String toString(Charset charset) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
        this.write(outputStreamWriter);
        String result = new String(outputStream.toByteArray(), charset);
        return result;
    }

    @Deprecated
    public void exportToFile(File file) throws Exception {
        this.write(file);
    }

    @Deprecated
    public void startExport(Writer writer) throws Exception {
        this.write(writer);
    }

    @Deprecated
    public String startExportAsString() throws Exception {
        return this.toString(Charset.defaultCharset());
    }

    @Deprecated
    public InputStream startExport() throws Exception {
        String content = this.toString(Charset.defaultCharset());
        return IOUtils.toInputStream((String)content);
    }
}

