/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.csv;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.nuiton.util.csv.Import;
import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportRuntimeException;
import org.nuiton.util.csv.ImportableColumn;

public class ImportToMap
extends Import<Map<String, Object>> {
    public static ImportToMap newImport(ImportModel<Map<String, Object>> model, InputStream inputStream) {
        return new ImportToMap(model, inputStream);
    }

    public static ImportToMap newImport(ImportModel<Map<String, Object>> model, Reader reader) {
        return new ImportToMap(model, reader);
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        this.prepareAndValidate();
        return new Iterator<Map<String, Object>>(){
            boolean hasNext;
            List<ImportableColumn<Map<String, Object>, Object>> columns;
            int lineNumber;
            final Map<String, Object> element;
            {
                this.hasNext = ImportToMap.this.readRow();
                this.columns = ImportToMap.this.getNonIgnoredHeaders();
                this.element = new HashMap<String, Object>();
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Map<String, Object> next() throws NoSuchElementException, ImportRuntimeException {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                ++this.lineNumber;
                this.element.clear();
                for (ImportableColumn<Map<String, Object>, Object> field : this.columns) {
                    String value = ImportToMap.this.readValue(field, this.lineNumber);
                    Object parsedValue = ImportToMap.this.parseValue(field, this.lineNumber, value);
                    ImportToMap.this.setValue(field, this.lineNumber, this.element, parsedValue);
                }
                this.hasNext = ImportToMap.this.readRow();
                return this.element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, InputStream inputStream) {
        super(mapImportModel, inputStream);
    }

    protected ImportToMap(ImportModel<Map<String, Object>> mapImportModel, Reader reader) {
        super(mapImportModel, reader);
    }
}

