/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.plugin.ReportRenderer;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.ClassPathI18nInitializer;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;

abstract class ReportMojoSupport
extends AbstractMavenReport {
    @Parameter(property="config.outputDirectory", defaultValue="${project.reporting.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(property="config.outputEncoding", defaultValue="${project.reporting.outputEncoding}", required=true)
    protected String outputEncoding;
    @Parameter(property="config.i18nBundleName")
    private String i18nBundleName;
    @Parameter(property="config.include")
    private String include;
    @Parameter(property="config.exclude")
    private String exclude;
    @Parameter(property="config.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="config.showOptionDetail", defaultValue="true")
    private boolean showOptionDetail;
    @Parameter(property="config.skip")
    private boolean skip;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Component
    private Renderer siteRenderer;
    @Component
    private I18N i18n;
    private ClassLoader newClassLoader;
    private Set<ApplicationConfigProvider> configProviders;

    ReportMojoSupport() {
    }

    public String getOutputName() {
        return "config-report";
    }

    public String getDescription(Locale locale) {
        return this.i18n.getString(this.getOutputName(), locale, "report.description");
    }

    public String getName(Locale locale) {
        return this.i18n.getString(this.getOutputName(), locale, "report.title");
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public boolean canGenerateReport() {
        return !this.skip;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected abstract ClassLoader createClassLoader() throws MavenReportException;

    protected void executeReport(Locale locale) throws MavenReportException {
        if (this.newClassLoader == null) {
            this.init(locale);
        } else {
            I18n.setDefaultLocale((Locale)locale);
        }
        ReportRenderer renderer = new ReportRenderer(this.getSink(), this.i18n, locale, this.getOutputName(), this.getOutputName(), this.configProviders, this.showOptionDetail);
        renderer.render();
    }

    private void init(Locale locale) throws MavenReportException {
        if (this.getLog().isDebugEnabled()) {
            this.verbose = true;
        }
        if (this.newClassLoader == null) {
            this.newClassLoader = this.createClassLoader();
        }
        Object initializer = StringUtils.isNotEmpty((String)this.i18nBundleName) ? new DefaultI18nInitializer(this.i18nBundleName, this.newClassLoader) : new ClassPathI18nInitializer(this.newClassLoader);
        I18n.init((I18nInitializer)initializer, (Locale)locale);
        if (this.configProviders == null) {
            HashSet<String> includes = null;
            if (StringUtils.isNotEmpty((String)this.include)) {
                includes = new HashSet<String>(Arrays.asList(this.include.split("\\s*,\\s*")));
                if (this.verbose) {
                    this.getLog().info((CharSequence)("config - includes : " + includes));
                }
            }
            HashSet<String> excludes = null;
            if (StringUtils.isNotEmpty((String)this.exclude)) {
                excludes = new HashSet<String>(Arrays.asList(this.exclude.split("\\s*,\\s*")));
                if (this.verbose) {
                    this.getLog().info((CharSequence)("config - excludes : " + excludes));
                }
            }
            this.configProviders = ApplicationConfigHelper.getProviders((ClassLoader)this.newClassLoader, includes, excludes, (boolean)this.verbose);
        }
    }

    ClassLoader createClassLoader(Set<String> paths) {
        HashSet<URL> urls = new HashSet<URL>();
        for (String fileName : paths) {
            File pathElem = new File(fileName);
            try {
                URL url = pathElem.toURI().toURL();
                urls.add(url);
                this.getLog().debug((CharSequence)("Added classpathElement URL " + url));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error in adding the classpath " + pathElem, e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }
}

