package org.nuiton.config.example;

import java.util.function.Supplier;
import javax.annotation.Generated;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;

@Generated(value = "org.nuiton.config.plugin.templates.ApplicationConfigTransformer", date = "Sun Oct 02 16:17:17 CEST 2016")
public abstract class GeneratedNuitonConfigExampleConfig implements Supplier<ApplicationConfig> {

    private ApplicationConfig applicationConfig;

    protected GeneratedNuitonConfigExampleConfig() {
        this(ApplicationConfigInit.forAllScopes());
    }

    protected GeneratedNuitonConfigExampleConfig(ApplicationConfigInit init) {
        this.applicationConfig = new ApplicationConfig(init);
        this.applicationConfig.loadDefaultOptions(NuitonConfigExampleConfigOption.values());
    
        for (NuitonConfigExampleConfigAction a : NuitonConfigExampleConfigAction.values()) {

            for (String alias : a.getAliases()) {
                applicationConfig.addActionAlias(alias, a.getAction());
            }
        }
    }

    @Override
    public ApplicationConfig get() {
        return applicationConfig;
    }

    protected void setOption(String key, Object attrName) {
        applicationConfig.setOption(key, String.valueOf(attrName));
    }

    public String getFirstName() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.FIRST_NAME.getKey());
    }

    public void setFirstName(String firstName) {
        setOption(NuitonConfigExampleConfigOption.FIRST_NAME.getKey(), firstName);
    }

    public String getLastName() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.LAST_NAME.getKey());
    }

    public void setLastName(String lastName) {
        setOption(NuitonConfigExampleConfigOption.LAST_NAME.getKey(), lastName);
    }

    public String getEmail() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.EMAIL.getKey());
    }

    public void setEmail(String email) {
        setOption(NuitonConfigExampleConfigOption.EMAIL.getKey(), email);
    }

    public String getTwitter() {
        return applicationConfig.getOption(NuitonConfigExampleConfigOption.TWITTER.getKey());
    }

    public void setTwitter(String twitter) {
        setOption(NuitonConfigExampleConfigOption.TWITTER.getKey(), twitter);
    }

    public int getAge() {
        return applicationConfig.getOptionAsInt(NuitonConfigExampleConfigOption.AGE.getKey());
    }

    public void setAge(int age) {
        setOption(NuitonConfigExampleConfigOption.AGE.getKey(), age);
    }

} //GeneratedNuitonConfigExampleConfig
