/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.maven.skin;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.codehaus.plexus.logging.Logger;

public class ScmwebeditorUtils {
    private Logger logger;
    private VelocityContext context;
    private List<Locale> locales;
    private Locale locale;
    private String scmwebeditorURL;
    private String siteXmlScmwebeditorURL;
    private String siteSourcesType;
    private MavenProject mavenProject;

    public ScmwebeditorUtils(VelocityContext context, Logger logger) {
        this.context = context;
        this.logger = logger;
    }

    public void setContext(VelocityContext context) {
        this.context = context;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setScmwebeditorURL(String scmwebeditorURL) {
        this.scmwebeditorURL = scmwebeditorURL;
    }

    public void setSiteSourcesType(String siteSourcesType) {
        this.siteSourcesType = siteSourcesType;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setSiteXmlScmwebeditorURL(String siteXmlScmwebeditorURL) {
        this.siteXmlScmwebeditorURL = siteXmlScmwebeditorURL;
    }

    public String getSiteXmlScmwebeditorURL() {
        return this.siteXmlScmwebeditorURL;
    }

    public boolean isCurrentFileEditable() {
        String editFile = this.getCurrentFileName();
        File file = this.getFile(editFile);
        this.getLogger().debug("[" + editFile + "] on filesystem = " + file);
        boolean exist = file.exists();
        return exist;
    }

    public String getCurrentFileScmwebeditorURL() {
        String editFile = this.getCurrentFileName();
        String relativePath = this.getRelativePath(editFile, '/');
        String result = this.scmwebeditorURL + relativePath;
        this.getLogger().debug("[" + editFile + "] scmwebeditor url = " + result);
        return result;
    }

    protected VelocityContext getContext() {
        return this.context;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected MavenProject getProject() {
        return this.mavenProject;
    }

    protected String getAlignedFileName() {
        return (String)this.context.get("alignedFileName");
    }

    protected String getCurrentFileName() {
        return (String)this.context.get("currentFileName");
    }

    protected boolean isFirstLocale() {
        return this.locale.equals(this.locales.get(0));
    }

    protected String getRelativePath(String editFile, char separator) {
        String alignedFileName = this.getAlignedFileName();
        int lastIndex = alignedFileName.lastIndexOf(".") + 1;
        if (lastIndex > 0) {
            editFile = editFile.substring(0, lastIndex);
        }
        String result = "src" + separator + "site" + separator;
        if (!this.isFirstLocale()) {
            result = result + this.locale.toString() + separator;
        }
        result = result + this.siteSourcesType + separator;
        result = result + editFile + this.siteSourcesType;
        return result;
    }

    protected File getFile(String editFile) {
        File basedir = this.getProject().getBasedir();
        String relativePath = this.getRelativePath(editFile, File.separatorChar);
        File result = new File(basedir, relativePath);
        return result;
    }
}

