/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.maven.skin;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.codehaus.plexus.logging.Logger;

public class ScmwebeditorUtils {
    private Logger logger;
    private VelocityContext context;
    private List<Locale> locales;
    private Locale locale;
    private String scmwebeditorPrefixURL;
    private String siteXmlScmwebeditorURL;
    private String siteSourcesType;
    private MavenProject mavenProject;
    private String currentFileName;
    private File file;
    private String scmwebeditorFileURL;

    public ScmwebeditorUtils(VelocityContext context, Logger logger) {
        this.context = context;
        this.logger = logger;
        this.currentFileName = (String)context.get("currentFileName");
    }

    public void buildStates() {
        File file = this.getFile(this.currentFileName);
        boolean exist = file.exists();
        boolean withVm = false;
        if (!exist && (file = new File(file.getAbsolutePath() + ".vm")).exists()) {
            exist = true;
            withVm = true;
        }
        if (exist) {
            this.getLogger().debug("[" + this.currentFileName + "] on filesystem = " + file);
            this.file = file;
            String relativePath = this.getRelativePath(this.currentFileName, '/');
            if (withVm) {
                relativePath = relativePath + ".vm";
            }
            this.scmwebeditorFileURL = this.scmwebeditorPrefixURL + relativePath;
            this.getLogger().debug("[" + this.currentFileName + "] scmwebeditor url = " + this.scmwebeditorFileURL);
        }
    }

    public void setContext(VelocityContext context) {
        this.context = context;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setScmwebeditorPrefixURL(String scmwebeditorPrefixURL) {
        this.scmwebeditorPrefixURL = scmwebeditorPrefixURL;
    }

    public void setSiteSourcesType(String siteSourcesType) {
        this.siteSourcesType = siteSourcesType;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void setSiteXmlScmwebeditorURL(String siteXmlScmwebeditorURL) {
        this.siteXmlScmwebeditorURL = siteXmlScmwebeditorURL;
    }

    public String getSiteXmlScmwebeditorURL() {
        return this.siteXmlScmwebeditorURL;
    }

    public boolean isCurrentFileEditable() {
        boolean exist = this.file != null;
        return exist;
    }

    public String getCurrentFileScmwebeditorURL() {
        return this.scmwebeditorFileURL;
    }

    protected VelocityContext getContext() {
        return this.context;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected MavenProject getProject() {
        return this.mavenProject;
    }

    protected String getCurrentFileName() {
        return this.currentFileName;
    }

    protected boolean isFirstLocale() {
        return this.locale.equals(this.locales.get(0));
    }

    protected String getRelativePath(String editFile, char separator) {
        int lastIndex = editFile.lastIndexOf(".") + 1;
        if (lastIndex > 0) {
            editFile = editFile.substring(0, lastIndex);
        }
        String result = "src" + separator + "site" + separator;
        if (!this.isFirstLocale()) {
            result = result + this.locale.toString() + separator;
        }
        result = result + this.siteSourcesType + separator;
        result = result + editFile + this.siteSourcesType;
        return result;
    }

    protected File getFile(String editFile) {
        File basedir = this.getProject().getBasedir();
        String relativePath = this.getRelativePath(editFile, File.separatorChar);
        File result = new File(basedir, relativePath);
        return result;
    }
}

