/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.nuiton:maven-license-plugin:3.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven License Plugin", 0);
        this.append(sb, "Plugin de gestion des licenses (et en-t\u00eates) dans un project maven 2.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 7 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-third-party".equals(this.goal)) {
            this.append(sb, "license:add-third-party", 0);
            this.append(sb, "The gola to generate the third-party file. This file contains for all dependencies of the project a line giving the license used by the dependency. It will also copy it in the class-path (says add the generated directory as a resource of the build).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "bundleThirdPartyPath (Default: META-INF/${project.artifactId}-THIRD-PARTY.txt)", 2);
                this.append(sb, "The path of the bundled third party file to produce when generateBundle is on.\nNote: This option is not available for pom module types.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedArtifacts", 2);
                this.append(sb, "A filter to exclude some ArtifactsIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "A filter to exclude some GroupIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfWarning (Default: false)", 2);
                this.append(sb, "A flag to fail the build if at least one dependency was detected without a license.", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "To force generation of the third-party file even if every thing is up to date.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateBundle (Default: false)", 2);
                this.append(sb, "A flag to copy a bundled version of the third-party file. This is usefull to avoid for a final application collision name of third party file. The file will be copied at the bundleThirdPartyPath location.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupByLicense (Default: false)", 2);
                this.append(sb, "A flag to change the grouping of the generated THIRD-PARTY file.\nBy default, group by dependecies.\n\nIf sets to true, the it will group by license type.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedArtifacts", 2);
                this.append(sb, "A filter to include only some ArtifactsIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "A filter to include only some GroupIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseMerges", 2);
                this.append(sb, "To merge licenses in final file.\nEach entry represents a merge (first license is main license to keep), licenses are separated by |.\n\nExample :\n\n\n<licenseMerges>\n<licenseMerge>The\u00a0Apache\u00a0Software\u00a0License|Version\u00a02.0,Apache\u00a0License,\u00a0Version\u00a02.0</licenseMerge>\n</licenseMerges>\n</pre>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "missingFile (Default: src/license/THIRD-PARTY.properties)", 2);
                this.append(sb, "The file where to fill the license for dependencies with unknwon license.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: target/generated-sources/license)", 2);
                this.append(sb, "Directory where to generate files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2);
                this.append(sb, "File where to wirte the third-party file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useMissingFile (Default: false)", 2);
                this.append(sb, "A flag to use the missing licenses file to consolidate the THID-PARTY file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "aggregate-add-third-party".equals(this.goal)) {
            this.append(sb, "license:aggregate-add-third-party", 0);
            this.append(sb, "This aggregator goal (will be executed only once and only on pom projects) executed the add-third-party on all his modules (in a parellel build cycle) then aggreates all the third-party files in final one in the pom project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "bundleThirdPartyPath (Default: META-INF/${project.artifactId}-THIRD-PARTY.txt)", 2);
                this.append(sb, "The path of the bundled third party file to produce when generateBundle is on.\nNote: This option is not available for pom module types.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedArtifacts", 2);
                this.append(sb, "A filter to exclude some ArtifactsIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "A filter to exclude some GroupIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfWarning (Default: false)", 2);
                this.append(sb, "A flag to fail the build if at least one dependency was detected without a license.", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "To force generation of the third-party file even if every thing is up to date.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateBundle (Default: false)", 2);
                this.append(sb, "A flag to copy a bundled version of the third-party file. This is usefull to avoid for a final application collision name of third party file. The file will be copied at the bundleThirdPartyPath location.", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupByLicense (Default: false)", 2);
                this.append(sb, "A flag to change the grouping of the generated THIRD-PARTY file.\nBy default, group by dependecies.\n\nIf sets to true, the it will group by license type.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedArtifacts", 2);
                this.append(sb, "A filter to include only some ArtifactsIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "A filter to include only some GroupIds", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseMerges", 2);
                this.append(sb, "To merge licenses in final file.\nEach entry represents a merge (first license is main license to keep), licenses are separated by |.\n\nExample :\n\n\n<licenseMerges>\n<licenseMerge>The\u00a0Apache\u00a0Software\u00a0License|Version\u00a02.0,Apache\u00a0License,\u00a0Version\u00a02.0</licenseMerge>\n</licenseMerges>\n</pre>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "missingFile (Default: src/license/THIRD-PARTY.properties)", 2);
                this.append(sb, "The file where to fill the license for dependencies with unknwon license.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: target/generated-sources/license)", 2);
                this.append(sb, "Directory where to generate files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2);
                this.append(sb, "File where to wirte the third-party file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useMissingFile (Default: false)", 2);
                this.append(sb, "A flag to use the missing licenses file to consolidate the THID-PARTY file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "comment-style-list".equals(this.goal)) {
            this.append(sb, "license:comment-style-list", 0);
            this.append(sb, "Displays all the available comment style to box file headers.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail", 2);
                this.append(sb, "A flag to display also the content of each license.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "license:help", 0);
            this.append(sb, "Display help information on maven-license-plugin.\nCall\n\u00a0\u00a0mvn\u00a0license:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "license-list".equals(this.goal)) {
            this.append(sb, "license:license-list", 0);
            this.append(sb, "Display all available licenses.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail", 2);
                this.append(sb, "A flag to display also the content of each license.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResolver", 2);
                this.append(sb, "the url of an extra license repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-file-header".equals(this.goal)) {
            this.append(sb, "license:update-file-header", 0);
            this.append(sb, "The goal to update (or add) the header on project source files.\nThis goal replace the update-header goal which can not deal with Copyright.\n\nThis goal use a specific project file descriptor project.xml to describe all files to update for a whole project.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addSvnKeyWords (Default: false)", 2);
                this.append(sb, "A flag to add svn:keywords on new header.\nWill add svn keywords :\n\nAuthor,\u00a0Id,\u00a0Rev,\u00a0URL\u00a0and\u00a0Date\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUpdateCopyright (Default: false)", 2);
                this.append(sb, "A flag to authorize update of the copyright part of the header.\nNote: By default, do NOT authorize it since copyright part should be handled by developpers (holder can change on each file for example).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUpdateDescription (Default: false)", 2);
                this.append(sb, "A flag to authorize update of the description part of the header.\nNote: By default, do NOT authorize it since description can change on each file).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUpdateLicense (Default: true)", 2);
                this.append(sb, "A flag to authorize update of the license part of the header.\nNote: By default, authorize it since license part should always be generated by the plugin.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "clearAfterOperation (Default: true)", 2);
                this.append(sb, "A flag to clear everything after execution.\nNote: This property should ONLY be used for test purpose.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "A flag to test plugin but modify no file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Specific files to excludes, separated by a comma. By default, thoses file type are excluded:\n-\tmodelisation\n-\timages\n\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraExtensions", 2);
                this.append(sb, "To associate extra extension files to an existing comment style.\nKeys of the map are the extension of extra files to treate, and the value is the comment style you want to associate.\n\nFor example, to treate file with extensions java2 and jdata as java files (says using the java comment style, declare this in your plugin configuration :\n\n<extraExtensions>\n<java2>java</java2>\n<jdata>java</jdata>\n</extraExtensions>\n\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreTag", 2);
                this.append(sb, "A tag to place on files that will be ignored by the plugin.\nSometimes, it is necessary to do this when file is under a specific license.\n\nNote: If no sets, will use the default tag %%Ignore-License\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "inceptionYear (Default: ${project.inceptionYear})", 2);
                this.append(sb, "Inception year of the project.\nWill be used as first year of copyright section in new header.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Specific files to includes, separated by a comma. By default, it is '** /*'.\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "A flag to keep a backup of every modified file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Name of the license to use in the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseResolver", 2);
                this.append(sb, "To specify an external extra licenses repository resolver (says the base url of the repository where the license.properties is present).", 3);
                this.append(sb, "", 0);
                this.append(sb, "organizationName (Default: ${project.organization.name})", 2);
                this.append(sb, "Name of project's organization.\nWill be used as copyrigth's holder in new header.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectName (Default: ${project.name})", 2);
                this.append(sb, "Name of project (or module).\nWill be used as description section of new header.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "roots", 2);
                this.append(sb, "To specify the base dir from which we apply the license.\nShould be on form 'root1,root2,rootn'.\n\nBy default, the main roots are 'src, target\ngenerated-sources, target/processed-sources'.\nNote: If some of these roots do not exist, they will be simply ignored.\n\nNote: This parameter is not useable if you are still using a project file descriptor.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipUpdateLicense (Default: false)", 2);
                this.append(sb, "A flag to skip the goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateCopyright (Default: false)", 2);
                this.append(sb, "A flag to update copyright application time (change copyright last year if required) according to the last commit made on the processed file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-project-license".equals(this.goal)) {
            this.append(sb, "license:update-project-license", 0);
            this.append(sb, "Updates (or creates) the main project license file according to the given license defines as licenseName.\nCan also generate a bundled license file (to avoid collision names in class-path). This file is by default generated in META-INF class-path directory.\n\nNote: this goal replace add-license one (which does not use license project descriptor).\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "bundleLicensePath (Default: META-INF/${project.artifactId}-LICENSE.txt)", 2);
                this.append(sb, "The path of the bundled license file to produce when generateBundle is on.\nNote: This option is not available for pom module types.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files.\nNote: If nothing is filled here, we will use the system property file.encoding.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "A flag to force to generate project license file even if it is up-to-date.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateBundle (Default: false)", 2);
                this.append(sb, "A flag to copy the main license file in a bundled place.\nThis is usefull for final application to have a none confusing location to seek for the application license.\n\nIf Sets to true, will copy the license file to the bundleLicensePath to outputDirectory.\n\nNote: This option is not available for pom module types.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "A flag to keep a backup of every modified file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseFile (Default: ${basedir}/LICENSE.txt)", 2);
                this.append(sb, "Project license file to synchronize with main license defined in descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Name of the license to use in the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseResolver", 2);
                this.append(sb, "To specify an external extra licenses repository resolver (says the base url of the repository where the license.properties is present).", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: target/generated-sources/license)", 2);
                this.append(sb, "The directory where to generate license resources.\nNote: This option is not available for pom module types.\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipUpdateProjectLicense (Default: false)", 2);
                this.append(sb, "A flag to skip the goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode.\nNote: Verbose mode is always on if you starts a debug maven instance (says via -X).\n", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

