/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.nuiton.io.SortedProperties;
import org.nuiton.license.plugin.AbstractAddThirdPartyMojo;
import org.nuiton.license.plugin.ArtifactHelper;
import org.nuiton.license.plugin.LicenseMap;
import org.nuiton.plugin.Plugin;

public class AddThirdPartyMojo
extends AbstractAddThirdPartyMojo {
    protected ArtifactRepository localRepository;
    protected List<?> remoteRepositories;
    protected MavenProjectBuilder mavenProjectBuilder;
    private boolean doGenerateMissing;

    protected boolean checkPackaging() {
        return this.rejectPackaging(new Plugin.Packaging[]{Plugin.Packaging.pom});
    }

    @Override
    protected LicenseMap createLicenseMap() throws ProjectBuildingException {
        Log log = this.getLog();
        LicenseMap licenseMap = new LicenseMap();
        licenseMap.setLog(log);
        boolean haveNoIncludedGroups = StringUtils.isEmpty((String)this.includedGroups);
        boolean haveNoIncludedArtifacts = StringUtils.isEmpty((String)this.includedArtifacts);
        boolean haveExcludedGroups = StringUtils.isNotEmpty((String)this.excludedGroups);
        boolean haveExcludedArtifacts = StringUtils.isNotEmpty((String)this.excludedArtifacts);
        boolean haveExclusions = haveExcludedGroups || haveExcludedArtifacts;
        Pattern includedGroupPattern = null;
        Pattern includedArtifactPattern = null;
        Pattern excludedGroupPattern = null;
        Pattern excludedArtifactPattern = null;
        if (!haveNoIncludedGroups) {
            includedGroupPattern = Pattern.compile(this.includedGroups);
        }
        if (!haveNoIncludedArtifacts) {
            includedArtifactPattern = Pattern.compile(this.includedArtifacts);
        }
        if (haveExcludedGroups) {
            excludedGroupPattern = Pattern.compile(this.excludedGroups);
        }
        if (haveExcludedArtifacts) {
            excludedArtifactPattern = Pattern.compile(this.excludedArtifacts);
        }
        for (Object o : this.getProject().getArtifacts()) {
            boolean isToExclude;
            Artifact artifact = (Artifact)o;
            if ("system".equals(artifact.getScope())) continue;
            String id = ArtifactHelper.getArtifactId(artifact);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("detected artifact " + id));
            }
            boolean isToInclude = haveNoIncludedArtifacts && haveNoIncludedGroups || this.isIncludable(artifact, includedGroupPattern, includedArtifactPattern);
            boolean bl = isToExclude = isToInclude && haveExclusions && this.isExcludable(artifact, excludedGroupPattern, excludedArtifactPattern);
            if (!isToInclude || isToExclude) continue;
            MavenProject project = this.addArtifact(id, artifact);
            licenseMap.addLicense(project, project.getLicenses());
        }
        return licenseMap;
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException {
        SortedProperties unsafeMappings = this.getLicenseMap().loadUnsafeMapping(this.getEncoding(), this.getMissingFile());
        SortedSet<MavenProject> unsafeDependencies = this.getUnsafeDependencies();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("found " + unsafeMappings.size() + " unsafe mappings"));
        }
        boolean generateMissingfile = this.computeDoGenerateMissingFile(unsafeMappings, unsafeDependencies);
        this.setDoGenerateMissing(generateMissingfile);
        if (generateMissingfile && this.isVerbose()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Will use from missing file ");
            sb.append(unsafeMappings.size());
            sb.append(" dependencies :");
            for (Map.Entry entry : unsafeMappings.entrySet()) {
                String id = (String)entry.getKey();
                String license = (String)entry.getValue();
                sb.append("\n - ").append(id).append(" - ").append(license);
            }
            this.getLog().info((CharSequence)sb.toString());
        } else if (this.isUseMissingFile() && !unsafeMappings.isEmpty()) {
            this.getLog().info((CharSequence)("Missing file " + this.getMissingFile() + " is up-to-date."));
        }
        return unsafeMappings;
    }

    protected boolean computeDoGenerateMissingFile(SortedProperties unsafeMappings, SortedSet<MavenProject> unsafeDependencies) throws IOException {
        if (!this.isUseMissingFile()) {
            return false;
        }
        if (this.isForce()) {
            return !CollectionUtils.isEmpty((Collection)unsafeMappings.keySet());
        }
        if (!CollectionUtils.isEmpty(unsafeDependencies)) {
            return true;
        }
        SortedProperties oldUnsafeMappings = new SortedProperties(this.getEncoding());
        oldUnsafeMappings.load(this.getMissingFile());
        return !unsafeMappings.equals((Object)oldUnsafeMappings);
    }

    protected boolean checkSkip() {
        if (!(this.isDoGenerate() || this.isDoGenerateBundle() || this.isDoGenerateMissing())) {
            this.getLog().info((CharSequence)"All files are up to date, skip goal execution.");
            return false;
        }
        return true;
    }

    protected void doAction() throws Exception {
        boolean unsafe = this.checkUnsafeDependencies();
        this.writeThirdPartyFile();
        if (this.isDoGenerateMissing()) {
            this.writeMissingFile();
        }
        if (unsafe && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some dependencies with no license, please fill the file " + this.getMissingFile());
        }
        this.addResourceDir(this.getOutputDirectory(), new String[]{"**/*.txt"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMissingFile() throws IOException {
        Log log = this.getLog();
        LicenseMap licenseMap = this.getLicenseMap();
        File file = this.getMissingFile();
        this.createDirectoryIfNecessary(file.getParentFile());
        log.info((CharSequence)("Regenerate missing license file " + file));
        FileWriter writer = new FileWriter(file);
        try {
            StringBuilder sb = new StringBuilder(" Generated by " + ((Object)((Object)this)).getClass().getName());
            ArrayList licenses = new ArrayList(licenseMap.keySet());
            licenses.remove(LicenseMap.getUnknownLicenseMessage());
            if (!licenses.isEmpty()) {
                sb.append("\n-------------------------------------------------------------------------------");
                sb.append("\n Already used licenses in project :");
                for (String license : licenses) {
                    sb.append("\n - ").append(license);
                }
            }
            sb.append("\n-------------------------------------------------------------------------------");
            sb.append("\n Please fill the missing licenses for dependencies :\n\n");
            this.getUnsafeMappings().store((Writer)writer, sb.toString());
        }
        finally {
            writer.close();
        }
    }

    protected MavenProject addArtifact(String id, Artifact artifact) throws ProjectBuildingException {
        MavenProject project = (MavenProject)AddThirdPartyMojo.getArtifactCache().get(id);
        Log log = this.getLog();
        if (project != null) {
            if (this.isVerbose()) {
                log.info((CharSequence)("add dependency [" + id + "] (from cache)"));
            }
        } else {
            project = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, true);
            if (this.isVerbose()) {
                log.info((CharSequence)("add dependency [" + id + "]"));
            }
            AddThirdPartyMojo.getArtifactCache().put(id, project);
        }
        return project;
    }

    public boolean isDoGenerateMissing() {
        return this.doGenerateMissing;
    }

    public void setDoGenerateMissing(boolean doGenerateMissing) {
        this.doGenerateMissing = doGenerateMissing;
    }

    protected boolean isIncludable(Artifact project, Pattern includedGroupPattern, Pattern includedArtifactPattern) {
        Matcher matchGroupId;
        Log log = this.getLog();
        if (includedGroupPattern != null) {
            try {
                matchGroupId = includedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Include " + project.getGroupId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                this.getLog().warn((CharSequence)("The pattern specified by expression <" + this.includedGroups + "> seems to be invalid."));
            }
        }
        if (includedArtifactPattern != null) {
            try {
                matchGroupId = includedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Include " + project.getArtifactId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                this.getLog().warn((CharSequence)("The pattern specified by expression <" + this.includedArtifacts + "> seems to be invalid."));
            }
        }
        return false;
    }

    protected boolean isExcludable(Artifact project, Pattern excludedGroupPattern, Pattern excludedArtifactPattern) {
        Matcher matchGroupId;
        Log log = this.getLog();
        if (excludedGroupPattern != null) {
            try {
                matchGroupId = excludedGroupPattern.matcher(project.getGroupId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Exclude " + project.getGroupId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                this.getLog().warn((CharSequence)("The pattern specified by expression <" + this.excludedGroups + "> seems to be invalid."));
            }
        }
        if (excludedArtifactPattern != null) {
            try {
                matchGroupId = excludedArtifactPattern.matcher(project.getArtifactId());
                if (matchGroupId.find()) {
                    if (log.isDebugEnabled()) {
                        log.debug((CharSequence)("Exclude " + project.getArtifactId()));
                    }
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                this.getLog().warn((CharSequence)("The pattern specified by expression <" + this.excludedArtifacts + "> seems to be invalid."));
            }
        }
        return false;
    }
}

