/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.nuiton.license.plugin.AbstractLicenseMojo;
import org.nuiton.plugin.Plugin;
import org.nuiton.plugin.PluginHelper;

public class AddThirdPartyMojo
extends AbstractLicenseMojo {
    private static final String unknownLicenseMessage = "Unknown license";
    protected File outputDirectory;
    protected String thirdPartyFilename;
    protected boolean generateBundle;
    protected String bundleThirdPartyPath;
    protected boolean force;
    protected boolean keepBackup;
    @Deprecated
    protected boolean copyToMETA_INF;
    protected ArtifactRepository localRepository;
    protected List<?> remoteRepositories;
    protected DependencyTreeBuilder dependencyTreeBuilder;
    protected ArtifactFactory factory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector collector;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected String thirdPartyFileContent;
    protected File thirdPartyFile;
    boolean doGenerate;
    public static final String NO_DEPENDENCIES_MESSAGE = "the project has no dependencies.";

    protected boolean checkPackaging() {
        return this.rejectPackaging(new Plugin.Packaging[]{Plugin.Packaging.pom});
    }

    protected void init() throws Exception {
        String content;
        if (this.getLog().isDebugEnabled()) {
            this.setVerbose(true);
        }
        if (this.copyToMETA_INF) {
            this.getLog().warn((CharSequence)"\\n copyToMETA_INF is deprecated, prefer use the generateBundle parameter\n\n");
            this.setGenerateBundle(true);
        }
        File file = new File(this.getOutputDirectory(), this.getThirdPartyFilename());
        this.setThirdPartyFile(file);
        this.setDoGenerate(this.isForce() || !file.exists() || !this.isFileNewerThanPomFile(file));
        if (this.isDoGenerate()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)"will generate third-party content...");
            }
            content = this.buildThirdPartyFilecontent();
        } else {
            content = PluginHelper.readAsString((File)this.getThirdPartyFile(), (String)this.getEncoding());
        }
        this.setThirdPartyFileContent(content);
    }

    protected void doAction() throws Exception {
        File target = this.getThirdPartyFile();
        if (this.isDoGenerate()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("writing third-party file : " + target));
            }
            if (this.isKeepBackup() && target.exists()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("backup " + target));
                }
                this.backupFile(target);
            }
            this.writeFile(target, this.getThirdPartyFileContent(), this.getEncoding());
        }
        File output = this.getOutputDirectory();
        if (this.isGenerateBundle()) {
            File bundleTarget = PluginHelper.getFile((File)output, (String[])new String[]{this.getBundleThirdPartyPath()});
            this.copyFile(target, bundleTarget);
        }
        this.addResourceDir(output, new String[]{"**/*.txt"});
    }

    protected String buildThirdPartyFilecontent() throws DependencyTreeBuilderException {
        ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter("test");
        DependencyNode dependencyTreeNode = this.dependencyTreeBuilder.buildDependencyTree(this.getProject(), this.localRepository, this.factory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.collector);
        LicenseMap licenseMap = new LicenseMap();
        for (Object o : dependencyTreeNode.getChildren()) {
            this.buildLicenseMap((DependencyNode)o, licenseMap);
        }
        Set unsafeDependencies = (Set)licenseMap.get(AddThirdPartyMojo.getUnknownLicenseMessage());
        if (unsafeDependencies != null) {
            for (String dep : unsafeDependencies) {
                this.getLog().warn((CharSequence)("no license found for dependency " + dep));
            }
        }
        StringBuilder sb = new StringBuilder();
        if (licenseMap.isEmpty()) {
            sb.append(NO_DEPENDENCIES_MESSAGE);
        } else {
            sb.append("List of third-party dependencies grouped by their license type.");
            for (String licenseName : licenseMap.keySet()) {
                sb.append("\n\n").append(licenseName).append(" : ");
                SortedSet projects = (SortedSet)licenseMap.get(licenseName);
                for (String projectName : projects) {
                    sb.append("\n  * ").append(projectName);
                }
            }
        }
        String content = sb.toString();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("third-party file content :\n" + content));
        }
        return content;
    }

    protected void buildLicenseMap(DependencyNode node, LicenseMap licenseMap) {
        if (node.getState() != 0) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("do not include this dependency " + node.toNodeString()));
            }
            return;
        }
        Artifact artifact = node.getArtifact();
        if (this.isVerbose() && this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("treate node " + node.toNodeString()));
        }
        if (!"system".equals(artifact.getScope())) {
            try {
                MavenProject artifactProject = this.getMavenProjectFromRepository(artifact);
                String artifactName = this.getArtifactName(artifactProject);
                List licenses = artifactProject.getLicenses();
                if (licenses.isEmpty()) {
                    licenseMap.put(AddThirdPartyMojo.getUnknownLicenseMessage(), artifactName);
                } else {
                    for (Object o : licenses) {
                        if (o == null) {
                            this.getLog().warn((CharSequence)("could not acquire the license for " + artifactName));
                            continue;
                        }
                        License license = (License)o;
                        String licenseKey = license.getName();
                        if (license.getName() == null) {
                            licenseKey = license.getUrl();
                        }
                        licenseMap.put(licenseKey, artifactName);
                    }
                }
            }
            catch (ProjectBuildingException e) {
                this.getLog().error((CharSequence)"ProjectBuildingException error : ", (Throwable)e);
            }
        }
        if (!node.getChildren().isEmpty()) {
            for (Object o : node.getChildren()) {
                this.buildLicenseMap((DependencyNode)o, licenseMap);
            }
        }
    }

    protected String getArtifactName(MavenProject artifactProject) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifactProject.getName());
        sb.append(" (");
        sb.append(artifactProject.getGroupId());
        sb.append(":");
        sb.append(artifactProject.getArtifactId());
        sb.append(":");
        sb.append(artifactProject.getVersion());
        sb.append(" - ");
        String url = artifactProject.getUrl();
        sb.append(url == null ? "no url defined" : url);
        sb.append(")");
        return sb.toString();
    }

    protected MavenProject getMavenProjectFromRepository(Artifact artifact) throws ProjectBuildingException {
        boolean allowStubModel = false;
        if (!"pom".equals(artifact.getType())) {
            artifact = this.factory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
            allowStubModel = true;
        }
        return this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, allowStubModel);
    }

    public static String getUnknownLicenseMessage() {
        return unknownLicenseMessage;
    }

    public String getThirdPartyFilename() {
        return this.thirdPartyFilename;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isKeepBackup() {
        return this.keepBackup;
    }

    public boolean isGenerateBundle() {
        return this.generateBundle;
    }

    public boolean isDoGenerate() {
        return this.doGenerate;
    }

    public String getBundleThirdPartyPath() {
        return this.bundleThirdPartyPath;
    }

    public File getThirdPartyFile() {
        return this.thirdPartyFile;
    }

    public String getThirdPartyFileContent() {
        return this.thirdPartyFileContent;
    }

    public void setThirdPartyFilename(String thirdPartyFilename) {
        this.thirdPartyFilename = thirdPartyFilename;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setKeepBackup(boolean keepBackup) {
        this.keepBackup = keepBackup;
    }

    public void setGenerateBundle(boolean generateBundle) {
        this.generateBundle = generateBundle;
    }

    public void setBundleThirdPartyPath(String bundleThirdPartyPath) {
        this.bundleThirdPartyPath = bundleThirdPartyPath;
    }

    public void setThirdPartyFileContent(String thirdPartyFileContent) {
        this.thirdPartyFileContent = thirdPartyFileContent;
    }

    public void setDoGenerate(boolean doGenerate) {
        this.doGenerate = doGenerate;
    }

    public void setThirdPartyFile(File thirdPartyFile) {
        this.thirdPartyFile = thirdPartyFile;
    }

    protected class LicenseMap
    extends TreeMap<String, SortedSet<String>> {
        private static final long serialVersionUID = 864199843545688069L;

        protected LicenseMap() {
        }

        @Override
        public SortedSet<String> put(String key, String value) {
            TreeSet<String> valueList = (TreeSet<String>)this.get(key);
            if (valueList == null) {
                valueList = new TreeSet<String>();
            }
            if (AddThirdPartyMojo.this.getLog().isDebugEnabled()) {
                AddThirdPartyMojo.this.getLog().debug((CharSequence)("key:" + key + ",value: " + value));
            }
            valueList.add(value);
            return this.put(key, valueList);
        }
    }
}

