/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.license.plugin.repository;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.nuiton.license.plugin.repository.License;
import org.nuiton.license.plugin.repository.LicenseDefinition;

public class LicenseRepository {
    public static final String REPOSITORY_DEFINITION_FILE = "licenses.properties";
    protected URL baseURL;
    protected LicenseRepository next;
    protected List<LicenseDefinition> definitions;
    protected final Map<LicenseDefinition, License> cache = new HashMap<LicenseDefinition, License>();
    protected boolean init;

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.checkNotInit();
        this.baseURL = baseURL;
    }

    public LicenseRepository appendRepository(LicenseRepository next) {
        LicenseRepository lastRepository = this.getLastRepository();
        lastRepository.next = next;
        return next;
    }

    public synchronized void reload() throws IOException {
        if (this.next != null) {
            this.next.reload();
        }
        this.init = false;
        this.cache.clear();
        this.load();
    }

    public synchronized void load() throws IOException {
        if (!this.init) {
            if (this.baseURL == null || this.baseURL.toString().trim().isEmpty()) {
                throw new IllegalStateException("no baseURL defined in " + this);
            }
            URL definitionURL = LicenseRepository.getUrl(this.baseURL, REPOSITORY_DEFINITION_FILE);
            this.definitions = new ArrayList<LicenseDefinition>();
            if (!this.checkExists(definitionURL)) {
                throw new IllegalArgumentException("no licenses.properties found withurl [" + definitionURL + "] for resolver " + this);
            }
            Properties p = new Properties();
            p.load(definitionURL.openStream());
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String licenseName = (String)entry.getKey();
                String licenseDescription = (String)entry.getValue();
                licenseName = licenseName.trim().toLowerCase();
                URL licenseURL = LicenseRepository.getUrl(this.baseURL, licenseName);
                LicenseDefinition def = new LicenseDefinition(licenseURL, licenseName, licenseDescription);
                this.definitions.add(def);
            }
            this.definitions = Collections.unmodifiableList(this.definitions);
        }
        if (this.next != null) {
            this.next.load();
        }
        this.init = true;
    }

    public List<LicenseDefinition> getAllDefinitions() {
        LicenseRepository[] repos = this.getAllRepositories();
        ArrayList<LicenseDefinition> result = new ArrayList<LicenseDefinition>(repos.length);
        for (LicenseRepository repo : repos) {
            result.addAll(repo.definitions);
        }
        return result;
    }

    public List<LicenseDefinition> getDefinitions() {
        return this.definitions;
    }

    public LicenseDefinition getDefinition(String licenseName) {
        this.checkInit();
        if (licenseName == null || licenseName.trim().isEmpty()) {
            throw new IllegalArgumentException("licenceName can not be null, nor empty");
        }
        licenseName = licenseName.trim().toLowerCase();
        LicenseDefinition definition = null;
        for (LicenseDefinition d : this.definitions) {
            if (!licenseName.equals(d.getName())) continue;
            definition = d;
            break;
        }
        if (definition == null && this.next != null) {
            definition = this.next.getDefinition(licenseName);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public License getLicense(String licenseName) throws IOException {
        this.checkInit();
        if (licenseName == null || licenseName.trim().isEmpty()) {
            throw new IllegalArgumentException("licenceName can not be null, nor empty");
        }
        LicenseDefinition definition = this.getDefinition(licenseName);
        License license = null;
        if (definition != null) {
            Map<LicenseDefinition, License> map = this.cache;
            synchronized (map) {
                license = this.cache.get(definition);
                if (license == null) {
                    URL licenseURL = definition.getLicenseURL();
                    URL headerURL = definition.getHeaderURL();
                    this.checkExists(licenseURL);
                    this.checkExists(headerURL);
                    license = new License();
                    license.setName(definition.getName());
                    license.setDescription(definition.getDescription());
                    license.setLicenseURL(licenseURL);
                    license.setHeaderURL(headerURL);
                    this.cache.put(definition, license);
                }
            }
        }
        return license;
    }

    public static URL getUrl(URL baseUrl, String suffix) throws IllegalArgumentException {
        String url = baseUrl.toString() + "/" + suffix;
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("could not obtain url " + url, ex);
        }
    }

    protected LicenseRepository getLastRepository() {
        LicenseRepository last = this.next == null ? this : this.next.getLastRepository();
        return last;
    }

    protected LicenseRepository[] getAllRepositories() {
        ArrayList<LicenseRepository> list = new ArrayList<LicenseRepository>();
        LicenseRepository repo = this;
        while (repo != null) {
            list.add(repo);
            repo = repo.next;
        }
        return list.toArray(new LicenseRepository[list.size()]);
    }

    protected boolean checkExists(URL url) throws IOException {
        URLConnection openConnection = url.openConnection();
        return openConnection.getContentLength() > 0;
    }

    protected void checkNotInit() throws IllegalStateException {
        if (this.init) {
            throw new IllegalStateException("license repository " + this + " was already initialize...");
        }
    }

    protected void checkInit() throws IllegalStateException {
        if (!this.init) {
            throw new IllegalStateException("repository " + this + " is not init, use the load method before any license request");
        }
    }
}

