/*
 * *##% 
 * Maven License Plugin
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license.plugin;

import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

import org.nuiton.license.plugin.repository.License;
import org.nuiton.license.plugin.repository.LicenseDefinition;
import org.nuiton.license.plugin.repository.LicenseRepository;
import org.nuiton.license.plugin.repository.LicenseRepositoryFactory;

/**
 * Display all available licenses.
 *
 * @author chemit
 * @goal license-list
 * @requiresProject false
 * @requiresDirectInvocation
 *
 * @since 1.0.1
 */
public class LicenseListMojo extends AbstractMojo {

    /**
     * La baseURL d'un resolver de license supplementaire
     *
     * @parameter expression="${extraResolver}"
     * @since 1.0.1
     */
    protected String extraResolver;
    /**
     * Encoding a utiliser pour lire et ecrire les fichiers.
     *
     * @parameter expression="${encoding}" default-value="UTF-8"
     * @required
     * @since 1.0.0
     */
    protected String encoding;
    /**
     * Un drapeau pour afficher aussi le contenu des license.
     *
     * @parameter expression="${detail}"
     * @since 1.0.1
     */
    protected boolean detail;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n\n-------------------------------------------------------------------------------\n");
        buffer.append("                           maven-license-plugin\n");
        buffer.append("-------------------------------------------------------------------------------\n\n");
        buffer.append("Available licenses :\n\n");

        LicenseRepository factory;
        try {
            factory = LicenseRepositoryFactory.newLicenseRepository(true, true, extraResolver);
        } catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("could not obtain the license repository", ex);
        } catch (IOException ex) {
            throw new MojoExecutionException("could not obtain the license repository", ex);
        }

        for (LicenseDefinition entry : factory.getDefinitions()) {
            String licenseName = entry.getName();
            buffer.append(" * ").append(licenseName).append(" : ").append(entry.getDescription()).append('\n');
            if (detail) {
                try {

                    License license = factory.getLicense(licenseName);
                    buffer.append("\n").append(license.getHeaderContent(encoding)).append("\n\n");
                } catch (IOException ex) {
                    throw new MojoExecutionException("could not instanciate license with name " + licenseName + " for reason " + ex.getMessage(), ex);
                }
            }
        }
        getLog().info(buffer.toString());
    }
}
