/*
 * #%L
 * Maven helper plugin
 * 
 * $Author: tchemit $
 * $LastChangedDate: 2010-04-10 22:36:03 +0200 (sam., 10 avril 2010) $
 * $LastChangedRevision: 692 $
 * $Id: PluginHelperTest.java 692 2010-04-10 20:36:03Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/maven-helper-plugin/tags/maven-helper-plugin-1.2.3/src/test/java/org/nuiton/plugin/PluginHelperTest.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.plugin;

import org.junit.Assert;
import org.junit.Test;

import java.io.File;
import java.net.URL;

/**
 * Tests the {@link PluginHelper} class.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2.3
 */
public class PluginHelperTest {

    @Test
    public void testGetLines() throws Exception {
        URL resource = getClass().getResource("urls.txt");
        File file = new File(resource.getFile());
        Assert.assertTrue(file.exists());
        String[] lines = PluginHelper.getLines(file);
        Assert.assertNotNull(lines);
        Assert.assertEquals(1, lines.length);
        Assert.assertEquals("file:///file.txt", lines[0]);
    }

    @Test
    public void testGetLinesAsURL() throws Exception {
        URL resource = getClass().getResource("urls.txt");
        File file = new File(resource.getFile());
        Assert.assertTrue(file.exists());
        URL[] urls = PluginHelper.getLinesAsURL(file);
        Assert.assertNotNull(urls);
        Assert.assertEquals(1, urls.length);
        Assert.assertEquals(new URL("file:///file.txt"), urls[0]);
    }

    @Test
    public void testGetLinesAsFiles() throws Exception {
        URL resource = getClass().getResource("urls.txt");
        File file = new File(resource.getFile());
        Assert.assertTrue(file.exists());
        File[] files = PluginHelper.getLinesAsFiles(file);
        Assert.assertNotNull(files);
        Assert.assertEquals(1, files.length);
        Assert.assertEquals(new File("file:///file.txt"), files[0]);
    }

}
