/*
 * *##% 
 * JRedmine client
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.io.xpp3;

/**
 * A enumaration to convert some data from a string representation.
 * <p/>
 *
 * @author chemit
 * @since 1.0.0
 */
public enum DefaultDataConverter implements DataConverter {

    Boolean {

        @Override
        public Object convert(String t) throws Exception {
            Object r = java.lang.Boolean.valueOf(t);
            return r;
        }
    },
    Short {

        @Override
        public Object convert(String t) throws Exception {
            Object r = java.lang.Short.valueOf(t);
            return r;
        }
    },
    Integer {

        @Override
        public Object convert(String t) throws Exception {
            Object r = java.lang.Integer.valueOf(t);
            return r;
        }
    },
    Long {

        @Override
        public Object convert(String t) throws Exception {
            Object r = java.lang.Long.valueOf(t);
            return r;
        }
    },
    Float {

        @Override
        public Object convert(String t) throws Exception {
            Object r = java.lang.Float.valueOf(t);
            return r;
        }
    },
    Double {

        @Override
        public Object convert(String t) throws Exception {
            Object r = java.lang.Double.valueOf(t);
            return r;
        }
    },
    Text {

        @Override
        public Object convert(String t) throws Exception {
            return t;
        }
    }
}