/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;

public class CollectFilesMojo
extends AbstractPlugin {
    protected MavenProject project;
    protected List attachedArtifacts;
    protected String extraFiles;
    protected String includes;
    protected String excludes;
    protected String outputDirectory;
    protected String descriptionFile;
    protected boolean includeAttached;
    protected boolean copyFiles;
    protected boolean verbose;
    protected boolean skip;
    protected boolean dryRun;
    protected String encoding;
    protected List<File> files;

    @Override
    protected void init() throws Exception {
        if (this.skip) {
            return;
        }
        this.files = this.getFiles();
    }

    @Override
    protected boolean checkSkip() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip flag is on, goal will not be executed.");
            return false;
        }
        if (this.files.isEmpty()) {
            this.getLog().warn((CharSequence)"No file to collect, goal will not be executed.");
            return false;
        }
        return true;
    }

    @Override
    public void doAction() throws Exception {
        MavenProject rootProject = this.getExecutionRootProject();
        File base = new File(rootProject.getBasedir(), this.outputDirectory);
        File output = new File(base, this.project.getGroupId() + "--" + this.project.getArtifactId());
        if (rootProject == this.project || this.verbose) {
            this.getLog().info((CharSequence)("Ouput dir : " + output));
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no file will be copied!\n");
        } else if (this.copyFiles) {
            this.createDirectoryIfNecessary(output);
        }
        File description = null;
        ArrayList<File> incomingFiles = null;
        boolean withDescriptionFile = false;
        if (this.descriptionFile != null && !this.descriptionFile.trim().isEmpty()) {
            description = new File(rootProject.getBasedir(), this.descriptionFile);
            withDescriptionFile = true;
            if (description.exists()) {
                try {
                    incomingFiles = this.getFiles(description);
                    this.getLog().info((CharSequence)("Loaded " + description));
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("could not load file " + description, (Exception)ex);
                }
            } else {
                incomingFiles = new ArrayList();
            }
        }
        if (!withDescriptionFile && !this.copyFiles) {
            throw new MojoExecutionException("must use at least one of the parameters 'copyFiles' or 'descriptionFile'");
        }
        String basedir = rootProject.getBasedir().getAbsolutePath();
        int basedirLength = basedir.length();
        for (File f : this.files) {
            String absolutePath = f.getAbsolutePath();
            String path = absolutePath.substring(basedirLength + 1);
            File dst = new File(output, f.getName());
            if (withDescriptionFile) {
                if (this.copyFiles) {
                    incomingFiles.add(dst);
                } else {
                    incomingFiles.add(f);
                }
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Collected file " + path));
            }
            if (this.dryRun || !this.copyFiles) continue;
            this.copyFile(f, dst);
        }
        if (!this.dryRun && withDescriptionFile) {
            try {
                this.setFiles(description, incomingFiles);
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Saved " + description));
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not save file " + description, (Exception)ex);
            }
        }
    }

    public List<File> getFiles(File input) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(Arrays.asList(PluginHelper.getLinesAsFiles(input)));
        return result;
    }

    public void setFiles(File output, List<File> files) throws IOException {
        StringBuilder builder = new StringBuilder();
        for (File f : files) {
            builder.append(f.getAbsolutePath()).append("\n");
        }
        this.writeFile(output, builder.toString(), this.encoding);
    }

    protected List<File> getFiles() {
        File file;
        Pattern includePattern = this.includes == null || this.includes.trim().isEmpty() ? null : Pattern.compile(this.includes.trim());
        Pattern excludePattern = this.excludes == null || this.excludes.trim().isEmpty() ? null : Pattern.compile(this.excludes.trim());
        ArrayList<File> result = new ArrayList<File>();
        if (this.includeAttached) {
            if ("pom".equals(this.project.getPackaging())) {
                this.addFile(this.project.getFile(), "adding artifact file : ", result, includePattern, excludePattern);
            } else {
                Artifact a = this.project.getArtifact();
                if (a != null) {
                    this.addFile(a.getFile(), "adding artifact file : ", result, includePattern, excludePattern);
                }
            }
        }
        if (this.extraFiles != null && !this.extraFiles.trim().isEmpty()) {
            File basedir = this.project.getBasedir();
            for (String path : this.extraFiles.split(",")) {
                file = (path = path.trim()).startsWith(basedir.getAbsolutePath()) ? new File(path.trim()) : new File(basedir, path.trim());
                this.addFile(file, "adding user file : ", result, includePattern, excludePattern);
            }
        }
        if (this.includeAttached && this.attachedArtifacts != null) {
            for (Object o : this.attachedArtifacts) {
                file = ((Artifact)o).getFile();
                this.addFile(file, "adding attached artifact file : ", result, includePattern, excludePattern);
            }
        }
        return result;
    }

    protected MavenProject getExecutionRootProject() {
        MavenProject root = this.project;
        while (!root.isExecutionRoot()) {
            root = root.getParent();
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("root project " + root));
        }
        return root;
    }

    protected void addFile(File f, String msg, List<File> files, Pattern includePattern, Pattern excludePattern) {
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            this.getLog().warn((CharSequence)("skip unexisting file " + f + " (" + msg + ")"));
            return;
        }
        if (excludePattern != null && excludePattern.matcher(f.getName()).matches()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("skip " + f + " : in excludes " + this.excludes));
            }
            return;
        }
        if (includePattern != null && !includePattern.matcher(f.getName()).matches()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("skip " + f + " : not in includes " + this.includes));
            }
            return;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)(msg + f));
        }
        files.add(f);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

