/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.mail.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.mailsender.MailMessage;
import org.codehaus.plexus.mailsender.MailSenderException;
import org.nuiton.mail.MailSender;
import org.nuiton.mail.ProjectJavamailMailSender;
import org.nuiton.plugin.AbstractPlugin;
import org.nuiton.plugin.PluginHelper;

public class SendEmailMojo
extends AbstractPlugin {
    protected MavenProject project;
    protected Settings settings;
    protected boolean verbose;
    private File emailContentFile;
    private String emailTitle;
    private String smtpHost;
    private int smtpPort;
    private String username;
    private String password;
    private boolean sslMode;
    private String fromDeveloperId;
    private MailSender mailSender;
    private List<String> toAddresses;
    private List<Developer> from;
    private String mailContentType;
    protected String encoding;
    private boolean skipSendEmail;
    protected boolean dryRun;
    private boolean runOnce;
    private boolean runOnceDone;

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    protected boolean init() throws Exception {
        String fromAddress;
        if (this.isGoalSkip()) {
            return true;
        }
        this.runOnceDone = false;
        if (this.runOnce && !this.isExecutionRoot()) {
            this.getLog().info((CharSequence)"runOnce flag is on, will skip the goal");
            this.runOnceDone = true;
            return true;
        }
        if (!this.emailContentFile.exists()) {
            this.getLog().warn((CharSequence)("could not find the template " + this.emailContentFile));
            this.getLog().warn((CharSequence)"will skip send email...");
            return false;
        }
        if (this.mailSender == null) {
            if (this.from == null || this.from.isEmpty()) {
                this.getLog().warn((CharSequence)"The <developers> section in your pom should not be empty. Add a <developer> entry or set the mailSender parameter.");
                this.getLog().warn((CharSequence)"will skip send email...");
                return false;
            }
            if (this.fromDeveloperId == null) {
                Developer dev = this.from.get(0);
                this.mailSender = new MailSender(dev.getName(), dev.getEmail());
            } else {
                for (Developer developer : this.from) {
                    if (!this.fromDeveloperId.equals(developer.getId())) continue;
                    this.mailSender = new MailSender(developer.getName(), developer.getEmail());
                    break;
                }
                if (this.mailSender == null) {
                    this.getLog().warn((CharSequence)("Missing developer with id '" + this.fromDeveloperId + "' in the <developers> section in your pom."));
                    this.getLog().warn((CharSequence)"will skip send email...");
                    return false;
                }
            }
        }
        if ((fromAddress = this.mailSender.getEmail()) == null || fromAddress.equals("")) {
            this.getLog().warn((CharSequence)("Invalid mail sender: name and email is mandatory (" + this.mailSender + ")."));
            this.getLog().warn((CharSequence)"will skip send email...");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        if (this.runOnce && this.runOnceDone) {
            return;
        }
        if (this.isGoalSkip()) {
            this.getLog().info((CharSequence)"skipGoal flag is on, the goal is skip.");
            return;
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no mail will be send!\n");
        }
        String newsContent = PluginHelper.readAsString(this.emailContentFile, this.encoding);
        MailMessage mailMsg = this.createMessage(newsContent, this.mailSender);
        ProjectJavamailMailSender mailer = this.createMailer();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("fromDeveloperId: " + this.fromDeveloperId));
        }
        if (this.dryRun) {
            this.getLog().info((CharSequence)("Mail title   : " + this.emailTitle));
            this.getLog().info((CharSequence)("Mail content :\n" + mailMsg.getContent()));
            return;
        }
        this.getLog().info((CharSequence)("Connecting to Host: " + this.smtpHost + ":" + this.smtpPort));
        try {
            mailer.send(mailMsg);
            this.getLog().info((CharSequence)"Sent...");
        }
        catch (MailSenderException e) {
            throw new MojoExecutionException("Failed to send email for reason " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected boolean isGoalSkip() {
        return this.skipSendEmail;
    }

    protected MailMessage createMessage(String newsContent, MailSender mailSender) throws MailSenderException {
        String fromName = mailSender.getName();
        String fromAddress = mailSender.getEmail();
        this.getLog().info((CharSequence)("Using this sender for email announcement: " + fromAddress + " < " + fromName + " > "));
        MailMessage mailMsg = new MailMessage();
        mailMsg.setSubject(this.emailTitle);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("email announcement :\n" + newsContent));
        }
        mailMsg.setContent(newsContent);
        mailMsg.setContentType(this.mailContentType);
        mailMsg.setFrom(fromAddress, fromName);
        for (String e : this.toAddresses) {
            this.getLog().info((CharSequence)("Sending mail to " + e + "..."));
            mailMsg.addTo(e, "");
        }
        return mailMsg;
    }

    protected ProjectJavamailMailSender createMailer() {
        ProjectJavamailMailSender mailer = new ProjectJavamailMailSender();
        ConsoleLogger logger = new ConsoleLogger(1, "base");
        if (this.getLog().isDebugEnabled()) {
            logger.setThreshold(0);
        }
        mailer.enableLogging((Logger)logger);
        mailer.setSmtpHost(this.smtpHost);
        mailer.setSmtpPort(this.smtpPort);
        mailer.setSslMode(this.sslMode);
        if (this.username != null) {
            mailer.setUsername(this.username);
        }
        if (this.password != null) {
            mailer.setPassword(this.password);
        }
        mailer.initialize();
        return mailer;
    }

    public void setMailSender(MailSender sender) {
        this.mailSender = sender;
    }

    public void setFrom(List<Developer> from) {
        this.from = from;
    }

    public void setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
    }

    @Override
    protected boolean isExecutionRoot() {
        return this.project.isExecutionRoot();
    }
}

