/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.io.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestDataNotFoundException;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;

public class RestSession {
    protected HttpClient client;
    protected static final Log log = LogFactory.getLog(RestSession.class);
    protected boolean open;
    protected boolean showRequest;
    protected RestClientConfiguration configuration;

    RestSession(RestClientConfiguration configuration) {
        this.showRequest = configuration.isVerbose();
        this.configuration = configuration;
        this.client = new HttpClient();
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(configuration.getRestUrl().getHost());
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)configuration.getEncoding());
        this.client.setHostConfiguration(hostConfiguration);
        this.client.setState(new HttpState());
    }

    public InputStream askData(RestRequest request) throws RestException, IOException {
        if (!this.open) {
            throw new IllegalStateException("the session is not opened");
        }
        HttpMethod gm = this.doRequest(request);
        StatusLine sl = gm.getStatusLine();
        int statusCode = sl.getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
        }
        if (statusCode == 404) {
            throw new RestDataNotFoundException("could not retreave some datas : " + gm.getResponseBodyAsString());
        }
        if (statusCode != 200) {
            log.error((Object)gm.getResponseBodyAsString());
            this.releaseConnection(this.getConnection());
            throw new RestException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
        }
        InputStream stream = gm.getResponseBodyAsStream();
        return stream;
    }

    public InputStream sendData(RestRequest request) throws RestException, IOException {
        if (!this.open) {
            throw new IllegalStateException("the session is not opened");
        }
        HttpMethod gm = this.doRequest(request);
        StatusLine sl = gm.getStatusLine();
        int statusCode = sl.getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug((Object)("status code " + statusCode + " for " + gm.getPath()));
        }
        if (statusCode != 200) {
            log.error((Object)gm.getResponseBodyAsString());
            this.releaseConnection(this.getConnection());
            throw new RestException("Got error code <" + statusCode + ":" + sl.getReasonPhrase() + "> on " + gm.getPath());
        }
        InputStream stream = gm.getResponseBodyAsStream();
        return stream;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void close() throws IOException {
        this.client.getState().clearCookies();
        this.releaseConnection(this.getConnection());
        this.open = false;
    }

    protected void releaseConnection(HttpConnection connection) {
        if (connection != null && connection.isOpen()) {
            this.client.getHttpConnectionManager().releaseConnection(connection);
        }
    }

    protected HttpConnection getConnection() {
        return this.client.getHttpConnectionManager().getConnection(this.client.getHostConfiguration());
    }

    protected String getUri(String ... paths) {
        String uri = this.client.getHostConfiguration().getHostURL();
        for (String path : paths) {
            uri = uri + '/' + path;
        }
        return uri;
    }

    public HttpMethod doRequest(RestRequest request) throws IOException {
        String uri = this.getUri(request.getPath());
        Object[] parameters = request.getParameters();
        Map<String, File> attachments = request.getAttachments();
        if (this.showRequest) {
            log.info((Object)("doRequest " + uri));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("doRequest with parameters : " + Arrays.toString(parameters)));
        }
        PostMethod gm = new PostMethod(uri);
        if (this.open) {
            Cookie[] cookies;
            for (Cookie c : cookies = this.client.getState().getCookies()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("push cookie : " + c.getName() + "=" + c.getValue()));
                }
                gm.addRequestHeader("Cookie", c.toExternalForm());
            }
        }
        if (attachments == null) {
            if (parameters.length > 0) {
                int nbParams = parameters.length / 2;
                for (int i = 0; i < nbParams; ++i) {
                    Object key = parameters[2 * i];
                    Object value = parameters[2 * i + 1];
                    if (value == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("skip null parameter " + (String)key));
                        continue;
                    }
                    gm.addParameter((String)key, (String)value);
                }
            }
        } else {
            ArrayList<Object> paramParts = new ArrayList<Object>();
            if (parameters.length > 0) {
                int nbParams = parameters.length / 2;
                for (int i = 0; i < nbParams; ++i) {
                    Object key = parameters[2 * i];
                    Object value = parameters[2 * i + 1];
                    if (value == null) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("skip null parameter " + (String)key));
                        continue;
                    }
                    paramParts.add(new StringPart((String)key, (String)value));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("add parameter [" + (String)key + "]=" + (String)value));
                }
            }
            for (Map.Entry<String, File> entry : attachments.entrySet()) {
                String key = entry.getKey();
                File file = entry.getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("add attachment " + key + "=" + file));
                }
                paramParts.add(new FilePart(key, file.getName(), file, "application/octet-stream", this.configuration.getEncoding()));
            }
            if (attachments.isEmpty()) {
                log.warn((Object)"no attachment in a multi-part request!");
            }
            Part[] parts = paramParts.toArray(new Part[paramParts.size()]);
            MultipartRequestEntity entity = new MultipartRequestEntity(parts, gm.getParams());
            if (log.isDebugEnabled()) {
                entity.writeRequest((OutputStream)System.out);
            }
            gm.setRequestEntity((RequestEntity)entity);
            gm.addRequestHeader("content-type", entity.getContentType());
            gm.addRequestHeader("content-length", entity.getContentLength() + "");
            if (this.showRequest) {
                log.info((Object)("content-type : " + entity.getContentType() + ", content-length : " + entity.getContentLength()));
            }
        }
        this.client.executeMethod((HttpMethod)gm);
        return gm;
    }
}

