/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.nuiton.util.FileUpdater;

@Deprecated
public class SourceEntry {
    protected String specificGoal = null;
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected String[] files;
    protected String[] skipFiles;
    protected String skipMessage;
    protected FileUpdater updater;

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public String getSpecificGoal() {
        return this.specificGoal;
    }

    public void setSpecificGoal(String specificGoal) {
        this.specificGoal = specificGoal;
    }

    public boolean useForGoal(String goal) {
        return this.specificGoal == null || this.specificGoal.equalsIgnoreCase(goal);
    }

    public boolean hasSrc() {
        return this.basedir != null;
    }

    public boolean hasIncludes() {
        return this.includes != null && this.includes.length > 0;
    }

    public boolean hasExcludes() {
        return this.excludes != null && this.excludes.length > 0;
    }

    public final boolean isFileUptodate(File file) {
        return this.updater != null && this.updater.isFileUpToDate(file);
    }

    public String[] getIncludedFiles(File defaultBasedir, String[] defaultIncludes, String[] defaultExcludes) {
        if (!this.hasSrc()) {
            this.setBasedir(defaultBasedir);
        }
        if (!this.hasIncludes()) {
            this.setIncludes(defaultIncludes);
        }
        if (!this.hasExcludes()) {
            this.setExcludes(defaultExcludes);
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.getBasedir());
        ds.setIncludes(this.getIncludes());
        if (this.hasExcludes()) {
            ds.setExcludes(this.getExcludes());
        }
        ds.scan();
        String[] foundFiles = ds.getIncludedFiles();
        return foundFiles;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("basedir:").append(this.basedir);
        if (this.includes != null) {
            sb.append(", includes:").append(Arrays.toString(this.includes));
        }
        if (this.excludes != null) {
            sb.append(", excludes:").append(Arrays.toString(this.excludes));
        }
        return sb.toString();
    }

    public String[] getIncludedFiles(File basedir, String[] defaultIncludes, String[] defaultExcludes, URLClassLoader loader, List<String> annotationClass, Log log) {
        ArrayList<String> result = new ArrayList<String>();
        for (String s : this.getIncludedFiles(basedir, defaultIncludes, defaultExcludes)) {
            if (!this.filterByAnnotation(s, loader, annotationClass, log)) continue;
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }

    protected boolean filterByAnnotation(String file, URLClassLoader loader, List<String> annotationClass, Log log) {
        boolean result;
        Annotation annotation = this.getAnnotation(file, loader, annotationClass, log);
        boolean bl = result = annotation != null;
        if (result && log.isDebugEnabled()) {
            log.debug((CharSequence)("find i18n annotated file  : " + file));
        }
        return result;
    }

    protected String getFQN(String file) {
        String filePath = file;
        filePath = filePath.substring(0, filePath.length() - ".java".length());
        String replaceEx = File.separator.equals("\\") ? "\\\\" : File.separator;
        return filePath.replaceAll(replaceEx, ".");
    }

    public Class<?> getClass(String file, URLClassLoader loader, Log log) {
        String fqn = this.getFQN(file);
        try {
            return loader.loadClass(fqn);
        }
        catch (Throwable e) {
            log.warn((CharSequence)("could not find class " + fqn + " " + e));
            return null;
        }
    }

    public Annotation getAnnotation(String file, URLClassLoader loader, List<String> annotationClass, Log log) {
        Class<?> currentClass = this.getClass(file, loader, log);
        try {
            Annotation[] annos = currentClass.getAnnotations();
            if (annos != null && annos.length > 0) {
                for (Annotation anno : annos) {
                    if (!annotationClass.contains(anno.annotationType().getName())) continue;
                    return anno;
                }
            }
        }
        catch (Throwable e) {
            log.warn((CharSequence)("could not find annotation for " + file + " " + e));
        }
        return null;
    }

    public Class<?> getClass(File file, URLClassLoader loader, Log log) {
        String f = file.getAbsolutePath().substring(this.basedir.getAbsolutePath().length() + 1);
        return this.getClass(f, loader, log);
    }

    public Annotation getAnnotation(File file, URLClassLoader loader, List<String> annotationClass, Log log) {
        String f = file.getAbsolutePath().substring(this.basedir.getAbsolutePath().length() + 1);
        return this.getAnnotation(f, loader, annotationClass, log);
    }

    public String getSkipMessage() {
        return this.skipMessage;
    }

    public String[] getFiles() {
        return this.files;
    }

    public String[] getSkipFiles() {
        return this.skipFiles;
    }

    public int getFoudFiles() {
        return this.skipFiles.length + this.files.length;
    }

    public FileUpdater getUpdater() {
        return this.updater;
    }

    public void setUpdater(FileUpdater updater) {
        this.updater = updater;
    }
}

