/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.io.rest;

import java.net.URL;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**
 * Default implementation of a {@link RestClientConfiguration}.
 * 
 * @author chemit
 * @since 1.0.3
 */
public class DefaultRestClientConfiguration implements RestClientConfiguration {

    URL restUrl;
    String restUsername;
    String restPassword;
    boolean verbose;
    String encoding;

    @Override
    public String getEncoding() {
        return encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String getRestPassword() {
        return restPassword;
    }

    @Override
    public void setRestPassword(String restPassword) {
        this.restPassword = restPassword;
    }

    @Override
    public URL getRestUrl() {
        return restUrl;
    }

    @Override
    public void setRestUrl(URL restUrl) {
        this.restUrl = restUrl;
    }

    @Override
    public String getRestUsername() {
        return restUsername;
    }

    @Override
    public void setRestUsername(String restUsername) {
        this.restUsername = restUsername;
    }

    @Override
    public boolean isVerbose() {
        return verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        b.append("redmineUrl", restUrl);
        b.append("redmineUsername", restUsername);
        b.append("redminePassword", "***");
        b.append("encoding", encoding);
        b.append("verbose", verbose);
        return b.toString();
    }
}
