/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.project.MavenProject;
import org.nuiton.AbstractPlugin;

public class RunJavaPlugin
extends AbstractPlugin {
    protected MavenProject project;
    protected String mainClass;
    protected String args;
    protected boolean verbose;
    protected Class<?> clazz;
    protected ClassLoader cl;

    public RunJavaPlugin() {
        super("");
    }

    @Override
    protected boolean ensurePackaging() {
        return this.project != null && ("pom".equals(this.project.getPackaging()) || "site".equals(this.project.getPackaging()));
    }

    @Override
    protected boolean init() throws Exception {
        this.cl = this.initClassLoader(this.project, new File(this.project.getBuild().getOutputDirectory()), false, false, false, true, true);
        Thread.currentThread().setContextClassLoader(this.cl);
        this.clazz = Class.forName(this.mainClass, true, this.cl);
        if (this.args == null) {
            this.args = "";
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread bootstrapThread = new Thread(threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Method main = Class.forName(RunJavaPlugin.this.mainClass, true, RunJavaPlugin.this.cl).getMethod("main", String[].class);
                    if (!main.isAccessible()) {
                        RunJavaPlugin.this.getLog().debug((CharSequence)"Setting accessibility to true in order to invoke main().");
                        main.setAccessible(true);
                    }
                    main.invoke((Object)main, new Object[]{RunJavaPlugin.this.args.split(" ")});
                }
                catch (NoSuchMethodException e) {
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", e));
                }
                catch (Exception e) {
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
                }
            }
        }, this.mainClass + ".main()");
        bootstrapThread.setContextClassLoader(this.cl);
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection<Thread> threads = this.getActiveThreads(threadGroup);
            for (Thread thread : threads) {
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    private void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    private Collection<Thread> getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }
}

