/*
 * *##% 
 * Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.license;

import org.junit.Test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/** @author chemit */
public class JarLicenseResolverTest extends BaseLicenseTestCase {

    @Test(expected = IllegalArgumentException.class)
    public void testResolvFailed1() throws Exception {
        new JarLicenseResolver().resolv(null);
    }

    @Test(expected = IllegalArgumentException.class)
    public void testResolvFailed2() throws Exception {
        new JarLicenseResolver().resolv("");
    }

    @Test(expected = IllegalArgumentException.class)
    public void testResolvFailed3() throws Exception {
        new JarLicenseResolver().resolv("  ");
    }

    @Test
    public void testResolv() throws Exception {
        JarLicenseResolver resolver = new JarLicenseResolver();

        {
            String name = "dummy_" + System.currentTimeMillis();
            License license = resolver.resolv(name);
            assertNull(license);
        }

        for (String name : new String[]{
                "gpl_v1",
                "gpl_v2",
                "gpl_v3",
                "lgpl_v2_1",
                "lgpl_v3"}) {
            License license = resolver.resolv(name);
            assertLicenseFound(name, license);
        }

    }

    @Test
    public void testGetLicenseNames() throws Exception {
        JarLicenseResolver resolver = new JarLicenseResolver();
        Map<String, String> licenseNames = resolver.getLicenseNames();

        assertEquals(Arrays.asList("gpl_v1",
                "gpl_v2",
                "gpl_v3",
                "lgpl_v2_1",
                "lgpl_v3"), new ArrayList<String>(licenseNames.keySet()));
    }


}
