/**
 * *##% Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.util;

import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.codehaus.plexus.PlexusContainer;
import org.junit.Before;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusTestCase;
import org.nuiton.AbstractPlugin;

/** @author chemit */
public abstract class BasePluginTestCase {

    protected static File basedir;
    protected static File testDir;
    protected static Iterator<PluginConfig> configItr;
    protected static MyAbstractMojoTestCase delegate;
    protected String goalName;
    protected File pomFile;
    protected AbstractPlugin mojo;

    protected static File getBaseDir() {
        if (basedir == null) {

            String path = PlexusTestCase.getBasedir();
            basedir = new File(path);
        }
        return basedir;
    }

    protected static File getTestDir() {
        return testDir;
    }

    protected static void initConfigs(Class<? extends BasePluginTestCase> klass, String... testNames) throws Exception {
        List<PluginConfig> configs = new ArrayList<PluginConfig>();
        String rep = klass.getName();
        rep = rep.replaceAll("\\.", File.separator);

        File f = new File(getBaseDir(), "target" + File.separator + "test-classes");
        //File f = new File(getBaseDir(), "src" + File.separator + "test" + File.separator + "resources");
        testDir = new File(f, rep);
        System.out.println("test dir : " + testDir);

        for (String testName : testNames) {
            Method m = klass.getMethod(testName);
            if (m == null) {
                throw new IllegalAccessException("could not find method " + testName + " on class " + klass.getName());
            }

            PluginConfig annotation = m.getAnnotation(PluginConfig.class);
            if (annotation == null) {
                throw new IllegalAccessException("could not find annotation " + PluginConfig.class.getName() + " on method " + testName);
            }
            configs.add(annotation);
        }

        delegate = new MyAbstractMojoTestCase();
        delegate.setUp();
        configItr = configs.iterator();
    }

    @Before
    public void setUp() throws Exception {
        initPomFile(configItr.next());
    }

    protected void initPomFile(PluginConfig pluginConfig) throws Exception {
        this.goalName = pluginConfig.goalName();
        this.pomFile = new File(getTestDir(), pluginConfig.pomName());
        this.mojo = (AbstractPlugin) delegate.lookupMojo(goalName, pomFile);

        MavenProject project = mojo.getProject();
        if (project == null) {
//            MavenProjectBuilder projectBuilder = (MavenProjectBuilder) delegate.getContainer().lookup(MavenProjectBuilder.ROLE);
//            ProjectBuilderConfiguration projectBuilderConfiguration = null;
//            project = projectBuilder.build(pomFile, projectBuilderConfiguration);

            project = new MavenProject();

            this.mojo.setProject(project);
        }

        this.mojo.getProject().setFile(pomFile);
    }

    public static class MyAbstractMojoTestCase extends AbstractMojoTestCase {

        @Override
        public Mojo lookupMojo(String goal, File pom) throws Exception {
            return super.lookupMojo(goal, pom);
        }

        @Override
        public void setUp() throws Exception {
            super.setUp();
        }

        @Override
        public void tearDown() throws Exception {
            super.tearDown();
        }

        @Override
        public PlexusContainer getContainer() {
            return super.getContainer();
        }
    }
}
