/**
 * *##% Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.license;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.InputStream;
import java.net.URL;
import org.codehaus.plexus.util.IOUtil;

/**
 * The model of a license.
 *
 * @author chemit
 */
public class License {

    /** the name of the licenses (ex lgpl-3.0) */
    protected String name;
    /** url of the license's content */
    protected URL licenseURL;
    /** url of the header's template */
    protected URL headerURL;

    public License() {
    }

    public String getName() {
        return name;
    }

    public URL getLicenseURL() {
        return licenseURL;
    }

    public URL getHeaderURL() {
        return headerURL;
    }

    public String getLicenseContent(String encoding) throws IOException {
        if (licenseURL == null) {
            throw new IllegalStateException("no licenseURL defined in " + this);
        }

        InputStream inputStream = licenseURL.openStream();
        Reader r = new BufferedReader(new InputStreamReader(inputStream, encoding));
        try {
            return IOUtil.toString(r);
//            return FileUtil.readAsString(r);
        } finally {
            r.close();
        }
    }

    public String getHeaderContent(String encoding) throws IOException {
        if (headerURL == null) {
            throw new IllegalStateException("no headerURL defined in " + this);
        }
        Reader r = new BufferedReader(new InputStreamReader(headerURL.openStream(), encoding));
        try {
            return IOUtil.toString(r);
//            return FileUtil.readAsString(r);
        } finally {
            r.close();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLicenseURL(URL licenseURL) {
        this.licenseURL = licenseURL;
    }

    public void setHeaderURL(URL headerURL) {
        this.headerURL = headerURL;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("<name:").append(name);
        sb.append(", licenseURL:").append(licenseURL.toString());
        sb.append(", headerURL:").append(headerURL.toString());
        sb.append(">");
        return sb.toString();
    }
}
