/**
 * *##% Maven helper plugin
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.license;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.net.URL;

/**
 * Un resolver de license dans le classpath.
 * <p/>
 * Le chemin de base est le suivant :
 * <pre>
 * /META-INF/licenses/
 * </pre>
 *
 * @author chemit
 * @see LicenseResolver
 */
public class JarLicenseResolver extends LicenseResolver {

    private static final Log log = LogFactory.getLog(JarLicenseResolver.class);

    public JarLicenseResolver() {
        super(acquireBaseURL());
    }

    protected static String acquireBaseURL() {
        String prefix = File.separator + "META-INF" + File.separator + "licenses";
        URL licenseURL = JarLicenseResolver.class.getResource(prefix);
        return licenseURL.toString();
    }
}
