/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.math.matrix.DoubleBigVector;
import org.nuiton.math.matrix.DoubleSparseArrayVector;
import org.nuiton.math.matrix.LazyVector;
import org.nuiton.math.matrix.MatrixException;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixNDImpl;
import org.nuiton.math.matrix.MatrixProvider;
import org.nuiton.math.matrix.MatrixProxy;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.math.matrix.Vector;

public class MatrixFactory {
    private static final Pattern DIM_AND_DEFAULT_LINE = Pattern.compile("^\\s*\\[((?:\\s*[0-9]+\\s*,?)+)\\]\\s*,?\\s*( *[+-]?[0-9]*\\.?[0-9]+([eE][+-]?[0-9]+)? *)?\\s*$");
    private static final Pattern SEMANTICS_LINE = Pattern.compile("^\\s*([^:]+)\\s*:\\s*(.+)\\s*$");
    private static final Pattern DATA_LINE = Pattern.compile("^(.*);(.*)$");
    protected static boolean defaultUseLazyVector = true;
    protected static Class<?> defaultVectorClass = DoubleBigVector.class;
    protected static Class<?> defaultSparseVectorClass = DoubleSparseArrayVector.class;
    protected static int defaultThresholdSparse = 1000;
    protected Class<?> vectorClass = null;
    protected Class<?> sparseVectorClass = null;
    protected int thresholdSparse = 1000;
    protected boolean useLazyVector = true;
    protected static SemanticMapper defaultSemanticMapper = new SemanticMapper();
    private static ThreadLocal<MatrixFactory> matrixFactoryThreadLocal = new ThreadLocal();

    protected MatrixFactory(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse, boolean useLazyVector) {
        this.vectorClass = vectorClass;
        this.sparseVectorClass = sparseVectorClass;
        this.thresholdSparse = thresholdSparse;
        this.useLazyVector = useLazyVector;
    }

    public Class<?> getVectorClass() {
        return this.vectorClass;
    }

    public Class<?> getSparseVectorClass() {
        return this.sparseVectorClass;
    }

    public int getThresholdSparse() {
        return this.thresholdSparse;
    }

    public boolean isUseLazyVector() {
        return this.useLazyVector;
    }

    public static void setDefaultVectorClass(Class<?> vectorClass) {
        defaultVectorClass = vectorClass;
    }

    public static void setDefaultSparseVectorClass(Class<?> defaultSparseVectorClass) {
        MatrixFactory.defaultSparseVectorClass = defaultSparseVectorClass;
    }

    public static void setDefaultThresholdSparse(int defaultThresholdSparse) {
        MatrixFactory.defaultThresholdSparse = defaultThresholdSparse;
    }

    public static void setDefaultUseLazyVector(boolean useLazyVector) {
        defaultUseLazyVector = useLazyVector;
    }

    public static Class<?> getDefaultVectorClass() {
        return defaultVectorClass;
    }

    public static void setSemanticMapper(SemanticMapper semanticMapper) {
        defaultSemanticMapper = semanticMapper;
    }

    public static SemanticMapper getSemanticMapper() {
        return defaultSemanticMapper;
    }

    public static MatrixFactory getInstance(Class<?> vectorClass) {
        return new MatrixFactory(vectorClass, vectorClass, 0, defaultUseLazyVector);
    }

    public static MatrixFactory getInstance(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse) {
        return new MatrixFactory(vectorClass, sparseVectorClass, thresholdSparse, defaultUseLazyVector);
    }

    public static MatrixFactory getInstance(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse, boolean useLazyVector) {
        return new MatrixFactory(vectorClass, sparseVectorClass, thresholdSparse, useLazyVector);
    }

    public static MatrixFactory getInstance() {
        MatrixFactory result = matrixFactoryThreadLocal.get();
        if (result == null) {
            result = MatrixFactory.getInstance(defaultVectorClass, defaultSparseVectorClass, defaultThresholdSparse, defaultUseLazyVector);
        }
        return result;
    }

    public static void initMatrixFactoryThreadLocal(Class<?> vectorClass, Class<?> sparseVectorClass, int thresholdSparse, boolean useLazyVector) {
        matrixFactoryThreadLocal.set(MatrixFactory.getInstance(vectorClass, sparseVectorClass, thresholdSparse, useLazyVector));
    }

    public static void removeMatrixFactoryThreadLocal() {
        matrixFactoryThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatrixND create(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String matrixName = file.getName();
            int extPos = matrixName.lastIndexOf(46);
            if (extPos != -1) {
                matrixName = matrixName.substring(0, extPos);
            }
            MatrixND result = this.create(in);
            result.setName(matrixName);
            MatrixND matrixND = result;
            return matrixND;
        }
    }

    public MatrixND create(Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line = this.readLine(in);
        if (line == null) {
            throw new MatrixException("Bad file format, file is not Matrix");
        }
        int[] dimensions = this.readDimensions(line);
        double defaultValue = this.readDefaultValue(line);
        List[] semantics = this.readSemantics(dimensions, in);
        MatrixND matrix = this.create(semantics);
        MatrixHelper.fill(matrix, defaultValue);
        line = this.readLine(in);
        while (line != null) {
            Matcher m = DATA_LINE.matcher(line);
            if (!m.matches()) {
                throw new MatrixException("Bad file format, can't read data");
            }
            int[] coords = this.readCoordinates(m.group(1));
            double val = this.readDouble(m.group(2));
            matrix.setValue(coords, val);
            line = this.readLine(in);
        }
        return matrix;
    }

    private String readLine(BufferedReader in) throws IOException {
        String line = in.readLine();
        while (line != null && StringUtils.isBlank((CharSequence)line)) {
            line = in.readLine();
        }
        return line;
    }

    private int[] readDimensions(String line) throws IOException {
        int[] dimensions;
        Matcher m = DIM_AND_DEFAULT_LINE.matcher(line);
        if (m.matches()) {
            String dimString = m.group(1);
            try {
                String[] dimArrayString = dimString.split("\\s*,\\s*");
                dimensions = new int[dimArrayString.length];
                int i = 0;
                for (String d : dimArrayString) {
                    dimensions[i++] = Integer.parseInt(d);
                }
            }
            catch (Exception eee) {
                throw new MatrixException("Can't parse dimension value: " + dimString, eee);
            }
        } else {
            throw new MatrixException("Line doesn't match dimension and default value information:" + line);
        }
        return dimensions;
    }

    private double readDefaultValue(String line) throws IOException {
        double defaultValue = 0.0;
        Matcher m = DIM_AND_DEFAULT_LINE.matcher(line);
        if (m.matches()) {
            String defaultValueString = m.group(2);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{defaultValueString})) {
                try {
                    defaultValue = Double.parseDouble(defaultValueString);
                }
                catch (Exception eee) {
                    throw new MatrixException("Can't parse default value: " + defaultValueString, eee);
                }
            }
        } else {
            throw new MatrixException("Line doesn't match dimension and default value information:" + line);
        }
        return defaultValue;
    }

    private List[] readSemantics(int[] dimensions, BufferedReader in) throws IOException {
        List[] semantics = new List[dimensions.length];
        for (int indexDim = 0; indexDim < dimensions.length; ++indexDim) {
            ArrayList<Object> sems;
            String line = this.readLine(in);
            if (line == null) {
                throw new MatrixException("Bad file format, file is not Matrix (semantics missing)");
            }
            Matcher m = SEMANTICS_LINE.matcher(line);
            if (m.matches()) {
                String type = m.group(1).trim();
                String[] semString = m.group(2).split("\\s*,\\s*");
                sems = new ArrayList<Object>();
                Class typeClass = MatrixFactory.getSemanticMapper().getType(type);
                for (String s : semString) {
                    Object value = MatrixFactory.getSemanticMapper().getValue(typeClass, s);
                    sems.add(value);
                }
                if (sems.size() != dimensions[indexDim]) {
                    throw new MatrixException(String.format("Semantics %d count not equals to semantics dimension, excepted %d, got %d", indexDim, dimensions[indexDim], sems.size()));
                }
            } else {
                throw new MatrixException("Bad file format, line is not a semantics declaration: " + line);
            }
            semantics[indexDim] = sems;
        }
        return semantics;
    }

    private int[] readCoordinates(String s) {
        String[] coords = s.split("\\s*;\\s*");
        int[] result = new int[coords.length];
        int max = coords.length;
        for (int i = 0; i < max; ++i) {
            try {
                result[i] = Integer.parseInt(coords[i]);
                continue;
            }
            catch (Exception eee) {
                throw new MatrixException("Can't parse coordinate value: " + s, eee);
            }
        }
        return result;
    }

    private double readDouble(String s) {
        try {
            double result = Double.parseDouble(s);
            return result;
        }
        catch (Exception eee) {
            throw new MatrixException("Can't parse value: " + s, eee);
        }
    }

    public MatrixND create(int[] dim) {
        return new MatrixNDImpl(this, dim);
    }

    public MatrixND create(double[] values, int[] dim) {
        int i;
        if (dim.length > 2) {
            return null;
        }
        MatrixNDImpl matrix = new MatrixNDImpl(this, dim);
        if (dim.length == 2) {
            for (i = 0; i < dim[0]; ++i) {
                for (int j = 0; j < dim[1]; ++j) {
                    int[] coordinates = new int[]{i, j};
                    matrix.setValue(coordinates, values[i * dim[1] + j]);
                }
            }
        }
        if (dim.length == 1) {
            for (i = 0; i < dim[0]; ++i) {
                int[] coordinates = new int[]{i};
                matrix.setValue(coordinates, values[i]);
            }
        }
        return matrix;
    }

    public MatrixND create(List<?>[] semantics) {
        return new MatrixNDImpl(this, semantics);
    }

    public MatrixND create(String name, int[] dim) {
        return new MatrixNDImpl(this, name, dim);
    }

    public MatrixND create(String name, int[] dim, String[] dimNames) {
        return new MatrixNDImpl(this, name, dim, dimNames);
    }

    public MatrixND create(String name, int[] dim, String[] dimNames, Vector data) {
        return new MatrixNDImpl(this, name, dim, dimNames, data);
    }

    public MatrixND create(String name, List<?>[] semantics) {
        return new MatrixNDImpl(this, name, semantics);
    }

    public MatrixND create(String name, List<?>[] semantics, String[] dimNames) {
        return new MatrixNDImpl(this, name, semantics, dimNames);
    }

    public MatrixND create(String name, List<?>[] semantics, String[] dimNames, Vector data) {
        return new MatrixNDImpl(this, name, semantics, dimNames, data);
    }

    public MatrixND create(MatrixND matrix) {
        return new MatrixNDImpl(this, matrix);
    }

    public MatrixND create(MatrixND matrix, Vector data) {
        return new MatrixNDImpl(this, matrix, data);
    }

    public MatrixND matrixId(int size) {
        MatrixND result = this.create(new int[]{size, size});
        for (int i = 0; i < size; ++i) {
            result.setValue(i, i, 1.0);
        }
        return result;
    }

    protected Vector createVector(long length) {
        try {
            Vector result = this.thresholdSparse <= 0 || length <= (long)this.thresholdSparse ? (Vector)this.vectorClass.newInstance() : (Vector)this.sparseVectorClass.newInstance();
            if (this.useLazyVector) {
                result = new LazyVector(result, length);
            }
            result.init(length);
            return result;
        }
        catch (Exception eee) {
            throw new RuntimeException("Can't create vector", eee);
        }
    }

    public MatrixProxy createProxy(List<?>[] semantics, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, semantics);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, int[] dim, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, dim);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, int[] dim, String[] dimNames, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, dim, dimNames);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, List<?>[] semantics, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, semantics);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }

    public MatrixProxy createProxy(String name, List<?>[] semantics, String[] dimNames, MatrixProvider matrixProvider) {
        MatrixProxy matrixProxy = new MatrixProxy(this, name, semantics, dimNames);
        matrixProxy.setMatrixProvider(matrixProvider);
        return matrixProxy;
    }
}

