/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import cern.colt.function.LongProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.LongArrayList;
import cern.colt.map.OpenLongDoubleHashMap;
import java.util.Arrays;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.SparseHashVectorIterator;
import org.nuiton.math.matrix.SparseVector;
import org.nuiton.math.matrix.Vector;
import org.nuiton.math.matrix.VectorForEachFunction;
import org.nuiton.math.matrix.VectorIterator;

public class DoubleSparseHashVector
implements SparseVector {
    protected double defaultValue = 0.0;
    protected OpenLongDoubleHashMap data;
    protected long capacity;

    public DoubleSparseHashVector() {
    }

    public DoubleSparseHashVector(long capacity) {
        this(capacity, 0.0);
    }

    public DoubleSparseHashVector(long capacity, double defaultValue) {
        this.init(capacity);
        this.defaultValue = defaultValue;
    }

    @Override
    public void init(long capacity) {
        if (this.data == null) {
            this.capacity = capacity;
            this.data = new OpenLongDoubleHashMap();
        }
    }

    @Override
    public String getInfo() {
        return "Double vector sparse(Colt): " + this.data.size() + "/" + this.size();
    }

    @Override
    public long getNumberOfAssignedValue() {
        return this.data.size();
    }

    @Override
    public long size() {
        return this.capacity;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        double result = this.defaultValue;
        if (this.capacity < (long)(2 * this.data.size())) {
            DoubleArrayList list = new DoubleArrayList(this.data.size());
            this.data.values(list);
            list.sort();
            double[] tmp = list.elements();
            int length = list.size();
            int max = 1;
            int count = 1;
            result = tmp[0];
            double old = tmp[0];
            double current = tmp[0];
            for (int i = 1; max < length - i + count && i < length; ++i) {
                current = tmp[i];
                if (current == old) {
                    ++count;
                    continue;
                }
                if (count > max) {
                    max = count;
                    result = old;
                }
                count = 1;
                old = current;
            }
            if (count > max) {
                max = count;
                result = current;
            }
            if ((long)max <= this.capacity - (long)length) {
                result = this.defaultValue;
            }
        }
        return result;
    }

    protected void checkPos(long pos) {
        if (pos < 0L || pos >= this.capacity) {
            throw new IllegalArgumentException("pos " + pos + " is not in [0, " + this.capacity + "]");
        }
    }

    @Override
    public double getValue(long pos) {
        this.checkPos(pos);
        double result = this.data.get(pos);
        if (result == 0.0 && this.defaultValue != 0.0 && !this.data.containsKey(pos)) {
            result = this.defaultValue;
        }
        return result;
    }

    @Override
    public void setValue(long pos, double value) {
        this.checkPos(pos);
        if (value == this.defaultValue) {
            this.data.removeKey(pos);
        } else {
            this.data.put(pos, value);
        }
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result) {
            if (o instanceof DoubleSparseHashVector && this.defaultValue == ((DoubleSparseHashVector)o).defaultValue) {
                DoubleSparseHashVector other = (DoubleSparseHashVector)o;
                result = this.data.equals(other.data);
            } else if (o instanceof Vector) {
                Vector other = (Vector)o;
                result = true;
                int i = 0;
                while ((long)i < this.size() && result) {
                    result = this.getValue(i) == other.getValue(i);
                    ++i;
                }
            }
        }
        return result;
    }

    public int hashCode() {
        return Long.hashCode(this.size());
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return this.size() == v.size();
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector v) {
        if (v instanceof DoubleSparseHashVector) {
            DoubleSparseHashVector vHash = (DoubleSparseHashVector)v;
            this.defaultValue = vHash.defaultValue;
            this.data = (OpenLongDoubleHashMap)vHash.data.copy();
        } else {
            this.defaultValue = 0.0;
            VectorIterator i = v.iteratorNotZero();
            while (i.hasNext()) {
                double val = i.next();
                long pos = i.getPosition();
                this.setValue(pos, val);
            }
        }
    }

    @Override
    public void map(final MapFunction f) {
        this.defaultValue = f.apply(this.defaultValue);
        this.data.forEachKey(new LongProcedure(){

            @Override
            public boolean apply(long i) {
                double value = DoubleSparseHashVector.this.data.get(i);
                if ((value = f.apply(value)) == DoubleSparseHashVector.this.defaultValue) {
                    DoubleSparseHashVector.this.data.removeKey(i);
                } else {
                    DoubleSparseHashVector.this.data.put(i, value);
                }
                return true;
            }
        });
    }

    @Override
    public long[] getAssignedPosition() {
        long[] result = this.data.keys().elements();
        Arrays.sort(result);
        return result;
    }

    @Override
    public double[] getAssignedValue() {
        double[] result = new double[this.data.size()];
        this.data.pairsSortedByKey(new LongArrayList(this.data.size()), new DoubleArrayList(result));
        return result;
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public VectorIterator iterator() {
        return new SparseHashVectorIterator(this);
    }

    @Override
    public VectorIterator iteratorNotZero() {
        return new SparseHashVectorIterator(this, 0.0);
    }

    @Override
    public void forEachNotZero(VectorForEachFunction f) {
        if (this.defaultValue == 0.0) {
            this.data.forEachPair((i, val) -> {
                f.apply(i, val);
                return true;
            });
        } else {
            SparseVector.super.forEachNotZero(f);
        }
    }
}

