/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.util.Arrays;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.Vector;

public class DoubleBigVector
implements Vector {
    protected double[] data = null;

    public DoubleBigVector() {
    }

    public DoubleBigVector(int capacity) {
        this.init(capacity);
    }

    @Override
    public void init(int capacity) {
        if (this.data == null) {
            this.data = new double[capacity];
        }
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        return MatrixHelper.maxOccurrence(this.data);
    }

    @Override
    public double getValue(int pos) {
        return this.data[pos];
    }

    @Override
    public void setValue(int pos, double value) {
        this.data[pos] = value;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof DoubleBigVector) {
            DoubleBigVector other = (DoubleBigVector)o;
            result = Arrays.equals(this.data, other.data);
        } else if (o instanceof Vector) {
            Vector other = (Vector)o;
            result = true;
            for (int i = 0; i < this.size() && result; ++i) {
                result = this.getValue(i) == other.getValue(i);
            }
        }
        return result;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return v instanceof DoubleBigVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector src) {
        DoubleBigVector fbv = (DoubleBigVector)src;
        System.arraycopy(fbv.data, 0, this.data, 0, this.size());
    }

    @Override
    public void add(Vector v) {
        DoubleBigVector fbv = (DoubleBigVector)v;
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] + fbv.data[i];
        }
    }

    @Override
    public void minus(Vector v) {
        DoubleBigVector fbv = (DoubleBigVector)v;
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            this.data[n] = this.data[n] - fbv.data[i];
        }
    }

    @Override
    public void map(MapFunction f) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = f.apply(this.data[i]);
        }
    }
}

