/*
 * #%L
 * NuitonMatrix
 * 
 * $Id: MatrixIteratorImpl.java 323 2011-01-22 09:32:20Z tchemit $
 * $HeadURL: https://nuiton.org/svn/nuiton-matrix/tags/nuiton-matrix-2.3.3/nuiton-matrix/src/main/java/org/nuiton/math/matrix/MatrixIteratorImpl.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix;

import java.util.List;

/**
 * MatrixIteratorImpl.
 *
 * Created: 28 oct. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * @version $Revision: 323 $
 *
 * Mise a jour: $Date: 2011-01-22 10:32:20 +0100 (Sat, 22 Jan 2011) $
 * par : $Author: tchemit $
 */
public class MatrixIteratorImpl implements MatrixIterator { // MatrixIteratorImpl

    protected BasicMatrixIterator iterator = null;
    protected List<?>[] semantics = null;
    protected int pos = 0;

    /**
     * @param iterator la matrice sur lequel l'iterator doit travailler
     * @param semantics la semantique de matrix, si matrix n'a pas de semantique
     *            alors il faut passer null
     */
    public MatrixIteratorImpl(BasicMatrixIterator iterator, List<?>[] semantics) {
        this.iterator = iterator;
        this.semantics = semantics;
        pos = 0;
    }

    @Override
    public boolean hasNext() {
        return iterator.hasNext();
    }

    @Override
    public boolean next() {
        return iterator.next();
    }

    @Override
    public int[] getCoordinates() {
        return iterator.getCoordinates();
    }

    @Override
    public double getValue() {
        return iterator.getValue();
    }

    @Override
    public void setValue(double value) {
        iterator.setValue(value);
    }

    @Override
    public Object[] getSemanticsCoordinates() {
        Object[] result = null;
        if (semantics != null) {
            int[] coordinates = getCoordinates();
            result = MatrixHelper.dimensionToSemantics(semantics,
                    coordinates);
        }
        return result;
    }

} // MatrixIteratorImpl

