/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import org.nuiton.math.matrix.gui.MatrixPopupMenu;
import org.nuiton.math.matrix.gui.MatrixTableModel;
import org.nuiton.math.matrix.gui.MatrixTableModelLinear;
import org.nuiton.math.matrix.gui.MatrixTableModelND;
import org.nuiton.math.matrix.gui.MatrixTableModelOption;

public class MatrixPanelEditorHandler {
    protected Collection<MatrixPanelListener> matrixPanelListeners = new HashSet<MatrixPanelListener>();
    protected MatrixPopupMenu popupMenu = null;

    public void addMatrixPanelListener(MatrixPanelListener l) {
        this.matrixPanelListeners.add(l);
    }

    public void removeMatrixPanelListener(MatrixPanelListener l) {
        this.matrixPanelListeners.remove(l);
    }

    protected void fireEvent(MatrixPanelEditor matrixPanelEditor) {
        MatrixPanelEvent event = new MatrixPanelEvent(matrixPanelEditor);
        for (MatrixPanelListener matrixPanelListener : this.matrixPanelListeners) {
            matrixPanelListener.matrixChanged(event);
        }
    }

    protected void initEditor(final MatrixPanelEditor matrixPanelEditor) {
        MatrixND matrix = matrixPanelEditor.getMatrix();
        JTable matrixTable = null;
        if (matrix != null) {
            this.popupMenu = new MatrixPopupMenu(matrixPanelEditor);
            matrixTable = new JTable(){

                @Override
                public void processMouseEvent(MouseEvent event) {
                    if (event.isPopupTrigger()) {
                        MatrixPanelEditorHandler.this.popupMenu.show(event.getComponent(), event.getX(), event.getY());
                    }
                    super.processMouseEvent(event);
                }
            };
            matrixTable.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
            matrixTable.getActionMap().put("copy", this.popupMenu.getSendToClipBoardSelectionCopyAction());
            matrixTable.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "paste");
            matrixTable.getActionMap().put("paste", this.popupMenu.getSendToClipBoardCurrentPasteAction());
            MatrixTableModel matrixTableModel = null;
            matrixTableModel = matrixPanelEditor.isLinearModel() != false ? new MatrixTableModelLinear(matrix, matrixPanelEditor.isLinearModelShowDefault()) : new MatrixTableModelND(matrix);
            if (matrixPanelEditor.isDisplayOptions().booleanValue()) {
                matrixTableModel = new MatrixTableModelOption(matrixTableModel, matrixPanelEditor.getSumOptionCheckBox().isSelected(), matrixPanelEditor.getMeanOptionCheckBox().isSelected(), matrixPanelEditor.getTransposeOptionCheckBox().isSelected());
            }
            matrixTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    matrixPanelEditor.fireEvent();
                }
            });
            matrixTable.setModel(matrixTableModel);
            matrixTable.setDefaultRenderer(String.class, matrixTableModel.getMatrixCellRenderer());
            matrixTable.setAutoResizeMode(0);
            matrixTable.setSelectionMode(1);
            matrixTable.setCellSelectionEnabled(true);
            matrixPanelEditor.table = matrixTable;
        }
        matrixPanelEditor.getEditArea().setViewportView(matrixTable);
        matrixPanelEditor.repaint();
    }

    public void modifyMatrixDimension(MatrixPanelEditor matrixPanelEditor) {
        String dim = JOptionPane.showInputDialog(matrixPanelEditor, I18n.t((String)"nuitonmatrix.create.matrix.message", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.create.matrix.title", (Object[])new Object[0]));
        if (dim != null && dim.indexOf(59) != -1) {
            String[] sdim = dim.split(";");
            int[] idim = new int[sdim.length];
            for (int i = 0; i < idim.length; ++i) {
                idim[i] = Integer.parseInt(sdim[i]);
            }
            MatrixND newMatrix = MatrixFactory.getInstance().create(idim);
            matrixPanelEditor.setMatrix(newMatrix);
        }
    }
}

