/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixEditor;
import org.nuiton.util.FileUtil;

public class MatrixPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 3349189688987885915L;
    private static final Log log = LogFactory.getLog(MatrixPopupMenu.class);
    protected MatrixEditor matrixEditor;
    protected JFileChooser fileChooser;
    protected JMenu sendToClipBoard;
    protected JMenu sendToFile;
    protected JCheckBoxMenuItem withSemantics;
    protected Action sendToClipBoardAllCopyAction;
    protected Action sendToClipBoardAllPasteAction;
    protected Action sendToClipBoardSelectionCopyAction;
    protected Action sendToClipBoardCurrentPasteAction;
    protected Action sendToFileAllCopyAction;
    protected Action sendToFileAllPasteAction;
    protected Action sendToFileSelectionCopyAction;
    protected Action sendToFileCurrentPasteAction;

    public MatrixPopupMenu(MatrixEditor matrixEditor) {
        this.matrixEditor = matrixEditor;
        this.sendToClipBoard = this.getSendToClipBoard();
        this.sendToFile = this.getSendToFile();
        this.withSemantics = new JCheckBoxMenuItem(I18n.t((String)"nuitonmatrix.menu.option.semantics", (Object[])new Object[0]), false);
        JMenu applyDataAction = this.getApplyDataAction();
        this.add(this.sendToClipBoard);
        this.add(this.sendToFile);
        this.add(this.withSemantics);
        this.add(new JSeparator());
        this.add(applyDataAction);
    }

    protected JMenu getSendToClipBoard() {
        if (this.sendToClipBoard == null) {
            this.sendToClipBoard = new JMenu(I18n.t((String)"nuitonmatrix.menu.action", (Object[])new Object[0]));
            JMenuItem sendToClipBoardAllCopy = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.action.copy", (Object[])new Object[0]));
            JMenuItem sendToClipBoardAllPaste = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.action.paste", (Object[])new Object[0]));
            JMenuItem sendToClipBoardSelectionCopy = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.action.copy.selection", (Object[])new Object[0]));
            JMenuItem sendToClipBoardCurrentPaste = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.action.paste.position", (Object[])new Object[0]));
            this.sendToClipBoard.add(sendToClipBoardAllCopy);
            this.sendToClipBoard.add(sendToClipBoardAllPaste);
            this.sendToClipBoard.add(new JSeparator());
            this.sendToClipBoard.add(sendToClipBoardSelectionCopy);
            this.sendToClipBoard.add(sendToClipBoardCurrentPaste);
            sendToClipBoardAllCopy.addActionListener(this.getSendToClipBoardAllCopyAction());
            sendToClipBoardAllPaste.addActionListener(this.getSendToClipBoardAllPasteAction());
            sendToClipBoardSelectionCopy.addActionListener(this.getSendToClipBoardSelectionCopyAction());
            sendToClipBoardCurrentPaste.addActionListener(this.getSendToClipBoardCurrentPasteAction());
        }
        return this.sendToClipBoard;
    }

    protected JMenu getSendToFile() {
        if (this.sendToFile == null) {
            this.sendToFile = new JMenu(I18n.t((String)"nuitonmatrix.menu.csv", (Object[])new Object[0]));
            JMenuItem sendToFileAllCopy = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.csv.export.file", (Object[])new Object[0]));
            JMenuItem sendToFileAllPaste = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.csv.import.file", (Object[])new Object[0]));
            JMenuItem sendToFileSelectionCopy = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.csv.export.selection", (Object[])new Object[0]));
            JMenuItem sendToFileCurrentPaste = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.csv.import.position", (Object[])new Object[0]));
            this.sendToFile.add(sendToFileAllCopy);
            this.sendToFile.add(sendToFileAllPaste);
            this.sendToFile.add(new JSeparator());
            this.sendToFile.add(sendToFileSelectionCopy);
            this.sendToFile.add(sendToFileCurrentPaste);
            sendToFileAllCopy.addActionListener(this.getSendToFileAllCopyAction());
            sendToFileAllPaste.addActionListener(this.getSendToFileAllPasteAction());
            sendToFileSelectionCopy.addActionListener(this.getSendToFileSelectionCopyAction());
            sendToFileCurrentPaste.addActionListener(this.getSendToFileCurrentPasteAction());
        }
        return this.sendToFile;
    }

    protected JMenu getApplyDataAction() {
        JMenu getApplyDataAction = new JMenu(I18n.t((String)"nuitonmatrix.menu.data", (Object[])new Object[0]));
        JMenuItem dataIdentityItem = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.data.identity", (Object[])new Object[0]));
        JMenuItem dataFillValueItem = new JMenuItem(I18n.t((String)"nuitonmatrix.menu.data.fillvalue", (Object[])new Object[0]));
        getApplyDataAction.add(dataIdentityItem);
        getApplyDataAction.add(dataFillValueItem);
        dataIdentityItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2263800006423028369L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MatrixPopupMenu.this.dataIdentityPerformed();
            }
        });
        dataFillValueItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2263800006423028369L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MatrixPopupMenu.this.dataFillValuePerformed();
            }
        });
        return getApplyDataAction;
    }

    protected Writer getFileChooserWriter() throws IOException {
        int returnVal = this.getFileChooser().showOpenDialog(this.matrixEditor);
        if (returnVal == 0) {
            File selectedFile = this.getFileChooser().getSelectedFile();
            if (!selectedFile.getName().endsWith(".csv")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".csv");
            }
            return FileUtil.getWriter((File)selectedFile);
        }
        return null;
    }

    protected Writer getClipBoardWriter() {
        return new StringWriter();
    }

    protected Reader getFileChooserReader() throws IOException {
        int returnVal = this.getFileChooser().showOpenDialog(this.matrixEditor);
        if (returnVal == 0) {
            File selectedFile = this.getFileChooser().getSelectedFile();
            return FileUtil.getReader((File)selectedFile);
        }
        return null;
    }

    protected Reader getClipBoardReader() throws UnsupportedFlavorException, IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(clipboard);
        if (contents != null) {
            String data = (String)contents.getTransferData(DataFlavor.stringFlavor);
            return new StringReader(data);
        }
        return null;
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        if (!this.getMatrix().isSupportedCSV()) {
            this.sendToClipBoard.setEnabled(false);
            this.sendToFile.setEnabled(false);
        } else {
            this.sendToClipBoard.setEnabled(true);
            this.sendToFile.setEnabled(true);
        }
        super.firePopupMenuWillBecomeVisible();
    }

    protected MatrixND getMatrix() {
        return this.matrixEditor.getMatrix();
    }

    protected MatrixND getSelectedMatrix() {
        int beginSelectedColumn = this.matrixEditor.getTable().getSelectedColumn();
        int nbSelectedColumn = this.matrixEditor.getTable().getSelectedColumnCount();
        int nbColumnDimRow = this.matrixEditor.getMatrix().getDimCount() - 1;
        if ((beginSelectedColumn -= nbColumnDimRow) < 0) {
            beginSelectedColumn = 0;
            nbSelectedColumn -= nbColumnDimRow;
        }
        int beginSelectedRow = this.matrixEditor.getTable().getSelectedRow() - 1;
        int nbSelectedRow = this.matrixEditor.getTable().getSelectedRowCount();
        MatrixND result = null;
        result = this.getMatrix().getDimCount() == 1 ? this.matrixEditor.getMatrix().getSubMatrix(0, beginSelectedColumn, nbSelectedColumn) : this.matrixEditor.getMatrix().getSubMatrix(0, beginSelectedRow, nbSelectedRow).getSubMatrix(1, beginSelectedColumn, nbSelectedColumn);
        return result;
    }

    protected int[] getCoordinatesFirstCellSelectedMatrix() {
        int selectedColumn = this.matrixEditor.getTable().getSelectedColumn();
        int nbColumnDimRow = this.matrixEditor.getMatrix().getDimCount() - 1;
        if ((selectedColumn -= nbColumnDimRow) < 0) {
            selectedColumn = 0;
        }
        int selectedRow = this.matrixEditor.getTable().getSelectedRow() - 1;
        return new int[]{selectedRow, selectedColumn};
    }

    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        return true;
                    }
                    String extension = FileUtil.extension((File)pathname, (String[])new String[0]);
                    if (extension != null) {
                        return extension.equals("csv");
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return "Texte CSV (*.csv)";
                }
            };
            this.fileChooser.setFileFilter(filter);
        }
        return this.fileChooser;
    }

    protected Action getSendToClipBoardAllCopyAction() {
        if (this.sendToClipBoardAllCopyAction == null) {
            this.sendToClipBoardAllCopyAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardAllCopyPerformed();
                }
            };
        }
        return this.sendToClipBoardAllCopyAction;
    }

    protected Action getSendToClipBoardAllPasteAction() {
        if (this.sendToClipBoardAllPasteAction == null) {
            this.sendToClipBoardAllPasteAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardAllPastePerformed();
                }
            };
        }
        return this.sendToClipBoardAllPasteAction;
    }

    protected Action getSendToClipBoardSelectionCopyAction() {
        if (this.sendToClipBoardSelectionCopyAction == null) {
            this.sendToClipBoardSelectionCopyAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardSelectionCopyPerformed();
                }
            };
        }
        return this.sendToClipBoardSelectionCopyAction;
    }

    public Action getSendToClipBoardCurrentPasteAction() {
        if (this.sendToClipBoardCurrentPasteAction == null) {
            this.sendToClipBoardCurrentPasteAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToClipBoardCurrentPastePerformed();
                }
            };
        }
        return this.sendToClipBoardCurrentPasteAction;
    }

    protected void sendToClipBoardAllCopyPerformed() {
        block2: {
            try {
                Writer writer = this.getClipBoardWriter();
                this.getMatrix().exportCSV(writer, this.withSemantics.getState());
                StringSelection contents = new StringSelection(writer.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(contents, contents);
                writer.close();
                this.matrixEditor.repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.clipboard.write", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.clipboard.write", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected void sendToClipBoardAllPastePerformed() {
        block2: {
            try {
                Reader reader = this.getClipBoardReader();
                this.getMatrix().importCSV(reader, new int[]{0, 0});
                reader.close();
                this.matrixEditor.fireEvent();
                this.matrixEditor.repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.clipboard.read", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.clipboard.read", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected void sendToClipBoardSelectionCopyPerformed() {
        block2: {
            try {
                Writer writer = this.getClipBoardWriter();
                this.getSelectedMatrix().exportCSV(writer, this.withSemantics.getState());
                StringSelection contents = new StringSelection(writer.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(contents, contents);
                writer.close();
                this.matrixEditor.repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.clipboard.write", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.clipboard.write", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected void sendToClipBoardCurrentPastePerformed() {
        block2: {
            try {
                Reader reader = this.getClipBoardReader();
                this.getMatrix().importCSV(reader, this.getCoordinatesFirstCellSelectedMatrix());
                reader.close();
                this.matrixEditor.fireEvent();
                this.matrixEditor.repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.clipboard.read", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.clipboard.read", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected Action getSendToFileAllCopyAction() {
        if (this.sendToFileAllCopyAction == null) {
            this.sendToFileAllCopyAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileAllCopyPerformed();
                }
            };
        }
        return this.sendToFileAllCopyAction;
    }

    protected Action getSendToFileAllPasteAction() {
        if (this.sendToFileAllPasteAction == null) {
            this.sendToFileAllPasteAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileAllPastePerformed();
                }
            };
        }
        return this.sendToFileAllPasteAction;
    }

    protected Action getSendToFileSelectionCopyAction() {
        if (this.sendToFileSelectionCopyAction == null) {
            this.sendToFileSelectionCopyAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileSelectionCopyPerformed();
                }
            };
        }
        return this.sendToFileSelectionCopyAction;
    }

    protected Action getSendToFileCurrentPasteAction() {
        if (this.sendToFileCurrentPasteAction == null) {
            this.sendToFileCurrentPasteAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    MatrixPopupMenu.this.sendToFileCurrentPastePerformed();
                }
            };
        }
        return this.sendToFileCurrentPasteAction;
    }

    protected void sendToFileAllCopyPerformed() {
        block3: {
            try {
                Writer writer = this.getFileChooserWriter();
                if (writer != null) {
                    this.getMatrix().exportCSV(writer, this.withSemantics.getState());
                    writer.close();
                    this.matrixEditor.repaint();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.file.write", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.file.write", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected void sendToFileAllPastePerformed() {
        block3: {
            try {
                Reader reader = this.getFileChooserReader();
                if (reader != null) {
                    this.getMatrix().importCSV(reader, new int[]{0, 0});
                    reader.close();
                    this.matrixEditor.fireEvent();
                    this.matrixEditor.repaint();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.file.read", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.file.read", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected void sendToFileSelectionCopyPerformed() {
        block3: {
            try {
                Writer writer = this.getFileChooserWriter();
                if (writer != null) {
                    this.getSelectedMatrix().exportCSV(writer, this.withSemantics.getState());
                    writer.close();
                    this.matrixEditor.repaint();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.file.write", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.file.write", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected void sendToFileCurrentPastePerformed() {
        block3: {
            try {
                Reader reader = this.getFileChooserReader();
                if (reader != null) {
                    this.getMatrix().importCSV(reader, this.getCoordinatesFirstCellSelectedMatrix());
                    reader.close();
                    this.matrixEditor.fireEvent();
                    this.matrixEditor.repaint();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.matrixEditor, I18n.t((String)"nuitonmatrix.error.file.read", (Object[])new Object[0]), I18n.t((String)"nuitonmatrix.error", (Object[])new Object[0]), 0);
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)I18n.t((String)"nuitonmatrix.error.file.read", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    protected void dataIdentityPerformed() {
        MatrixHelper.convertToId((MatrixND)this.getMatrix());
        this.matrixEditor.fireEvent();
        this.matrixEditor.repaint();
    }

    protected void dataFillValuePerformed() {
        String stringValue = JOptionPane.showInputDialog(this.matrixEditor, (Object)I18n.t((String)"nuitonmatrix.menu.data.fillvalue.ask", (Object[])new Object[0]));
        if (stringValue != null) {
            try {
                double value = Double.parseDouble(stringValue);
                MatrixHelper.fill((MatrixND)this.getMatrix(), (double)value);
                this.matrixEditor.fireEvent();
                this.matrixEditor.repaint();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

