/*
 * #%L
 * 
 * 
 * $Id: MatrixDimensionAction.java 346 2011-04-07 12:26:45Z echatellier $
 * $HeadURL: https://svn.nuiton.org/nuiton-matrix/tags/nuiton-matrix-2.4/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/MatrixDimensionAction.java $
 * %%
 * Copyright (C) 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix.viewer;

import javax.swing.Icon;

/**
 * Action de regroupement des valeurs d'une dimension, pour faire des sommes...
 * 
 * @author chatellier
 * @version $Revision: 346 $
 * 
 * Last update : $Date: 2011-04-07 14:26:45 +0200 (Thu, 07 Apr 2011) $
 * By : $Author: echatellier $
 */
public interface MatrixDimensionAction {

    /**
     * Action icon.
     * 
     * @return action icon
     */
    public Icon getIcon();
    
    /**
     * Action selected icon.
     * 
     * @return action selected icon
     */
    public Icon getSelectedIcon();

    /**
     * Return l'index de la dimension sur lequel porte l'action.
     * 
     * Used only if {@link #getDimensionType} returns {@code null}.
     * 
     * Return -1 to affect all dimensions.
     * 
     * @return dimension index
     */
    public int getDimensionIndex();

    /**
     * Return le type de dimension concerné par les actions.
     * 
     * @return dimension type
     */
    public Class<?> getDimensionType();
    
    /**
     * Method getSumStep indique le pas d'increment pour la somme sur
     * la dimension.
     * 
     * @return -1 indique de faire la somme sur tous les elements. 1
     * indique de faire la somme 1 a 1 (donc de ne pas faire de
     * somme), 2 indiques de faire la somme 2 a 2, ...
     */
    public int getSumStep();
}
