/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.viewer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.math.matrix.viewer.renderer.jfreechart.GraphComboRenderer;
import org.nuiton.math.matrix.viewer.renderer.jfreechart.GraphMatrixNDDataset;
import org.nuiton.math.matrix.viewer.renderer.jfreechart.GraphRendererComboBoxModel;
import org.nuiton.util.Resource;

public class MatrixChartRenderer
implements MatrixRenderer {
    protected JComboBox chartRendererComboBox;
    protected JFreeChart chart;

    @Override
    public Component getComponent(MatrixND matrix) {
        JPanel panel = this.getJFreeChartPanel(matrix);
        return panel;
    }

    @Override
    public Icon getIcon() {
        return Resource.getIcon((String)"/icons/chart_curve.png");
    }

    @Override
    public String getName() {
        return I18n.t((String)"nuitonmatrix.viewer.renderer.chart", (Object[])new Object[0]);
    }

    protected JPanel getJFreeChartPanel(MatrixND matrix) {
        JPanel panel = new JPanel(new BorderLayout());
        this.chartRendererComboBox = this.getChartRendererComboBox();
        panel.add((Component)this.chartRendererComboBox, "North");
        this.chart = this.getJFreeChart(matrix);
        panel.add((Component)this.getChartPanel(this.chart), "Center");
        return panel;
    }

    protected JComboBox getChartRendererComboBox() {
        JComboBox<Object> rendererComboBox = new JComboBox<Object>();
        GraphRendererComboBoxModel rendererComboBoxModel = new GraphRendererComboBoxModel();
        rendererComboBox.setModel(rendererComboBoxModel);
        rendererComboBox.setRenderer(new GraphComboRenderer());
        rendererComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CategoryItemRenderer renderer = (CategoryItemRenderer)e.getItem();
                MatrixChartRenderer.this.chart.getCategoryPlot().setRenderer(renderer);
            }
        });
        return rendererComboBox;
    }

    protected CategoryDataset getCategoryDataset(MatrixND matrix) {
        GraphMatrixNDDataset categoryDataset = new GraphMatrixNDDataset(matrix);
        return categoryDataset;
    }

    protected CategoryAxis getCategoryAxis(MatrixND matrix) {
        CategoryAxis horizontalAxis = new CategoryAxis();
        horizontalAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        horizontalAxis.setLabel(I18n.t((String)matrix.getDimensionName(0), (Object[])new Object[0]));
        return horizontalAxis;
    }

    protected ValueAxis getValueAxis(MatrixND matrix) {
        NumberAxis3D verticalAxis = new NumberAxis3D();
        return verticalAxis;
    }

    protected CategoryPlot getCategoryPlot(MatrixND matrix) {
        CategoryPlot categoryPlot = new CategoryPlot(this.getCategoryDataset(matrix), this.getCategoryAxis(matrix), this.getValueAxis(matrix), (CategoryItemRenderer)this.chartRendererComboBox.getSelectedItem());
        return categoryPlot;
    }

    protected JFreeChart getJFreeChart(MatrixND matrix) {
        JFreeChart chart = new JFreeChart(I18n.t((String)matrix.getName(), (Object[])new Object[0]), JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.getCategoryPlot(matrix), true);
        return chart;
    }

    protected ChartPanel getChartPanel(JFreeChart chart) {
        ChartPanel chartPanel = new ChartPanel(chart);
        return chartPanel;
    }
}

