/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import org.nuiton.math.matrix.gui.MatrixPopupMenu;
import org.nuiton.math.matrix.gui.MatrixTableModel;
import org.nuiton.math.matrix.gui.MatrixTableModelLinear;
import org.nuiton.math.matrix.gui.MatrixTableModelND;

public class MatrixPanelEditor
extends MatrixEditor
implements JAXXObject {
    public static final String PROPERTY_DIMENSION_EDIT = "dimensionEdit";
    public static final String PROPERTY_LINEAR_MODEL = "linearModel";
    public static final String PROPERTY_LINEAR_MODEL_SHOW_DEFAULT = "linearModelShowDefault";
    public static final String PROPERTY_TABLE_MODEL = "tableModel";
    public static final String BINDING_BUTTON_EDIT_VISIBLE = "buttonEdit.visible";
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1UTU8TQRh+W2mhraCAIkZIUIkXzFYxniDIl0RIUUM9EHtx2h3bIdOZdWYWFg/Gn+BP0LsXE2+ejAfPHrwY/4IxHrwa39ltuxSWj0R72Lb7Pu8zzzzzPvP2B2S0gstbJAgc5QvDmtRZW9jcfFDdojWzTHVNMc9IBdEnlYZ0BQpu5702cLVSsu3FVntxSTY9KajY0z1Tgrw2u5zqBqXGwHh3R03rYrlTngk8X7VZO6KSWF//+pl+5b58kwYIPFRXwK1MHNcV76SnBGnmGhjClbZJkRNRRxmKiTrq7bfvljjR+j5p0mfwAnpLkPWIQjIDV06+5ZAj7A88AwOT6wSXCO66DEE3DFyXqu4IH/8Jp0lMwz6w7tR95kTQh0RQHuE9L2TKGsgbUuV0XbqUG5g6luNRBx1TFDgTlKgWx6Ddr2M9cBal5JSIGDmyB1luyJ1l+pT43NjqYIzqd9EKoZkUVuy+4vBkOTRmVTDDCGfPqd38tfCwauge41Q5kXfOAeSRNDdtafRIyPQ+SB9FgQuKEgMX7LYDR+/gqTtr2Ck5t4ZbZK7TkAndxknpQoemWsR4fCxV35jIAFTShV4MKy1eBZe65hQT4MQJiEc0VYGM8vG1gdHKwdBsYCmKy+i+uFjCsPpnZPjrh+/vV9oZyeLa5xOheyKOs+sp6VFlmF36TBQQ3zBeXCfeTAVymnK8H8L8jyUIK7fKKA7Xi2bLtjv3iG4gRab328dPI0++nIL0CuS5JO4KsfhVyJmGQhckdwPvznyo6PROHz7PWm0GspzsSrQSBmZdYshElQkX/Z0L0ISxBBM6Sqq5z7+Hy+/m20akUNjFQ+GxGZnHkGXCJiC8Llo3QeL1UPA09V0ZJz7pDkjZ77zXmsap8FlM2ukA8Y3coBon2CbP4qYD337dCuXbX7dDtssnYDtXo5xHu7MJFXZ23X/k7Ndtvv8gsMfQAI91aDYye4IYvLgwTnQumXPyBJy920yzVkgPkWZp/gKZI43CBgcAAA==";
    private static final Log log = LogFactory.getLog(MatrixPanelEditor.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected JButton buttonEdit;
    protected Boolean dimensionEdit;
    protected JScrollPane editArea;
    protected Boolean linearModel;
    protected Boolean linearModelShowDefault;
    protected JTable table;
    protected MatrixTableModel tableModel;
    private MatrixPanelEditor $MatrixEditor0 = this;
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 150;
    protected Collection<MatrixPanelListener> matrixPanelListeners;
    protected MatrixPopupMenu popupMenu;
    protected MatrixND matrix;

    public MatrixPanelEditor(MatrixND m, boolean dimensionEdit) {
        this(dimensionEdit, 150, 150);
        this.matrix = m;
        JAXXUtil.assignment((Object)this.matrix, (String)"matrix", (JAXXObject)this);
    }

    public MatrixPanelEditor(boolean dimensionEdit, int width, int height) {
        this.dimensionEdit = dimensionEdit;
        this.setPreferredSize(new Dimension(width, height));
        this.$initialize();
    }

    public MatrixPanelEditor(boolean dimensionEdit) {
        this(dimensionEdit, 150, 150);
    }

    @Override
    public void setMatrix(MatrixND m) {
        this.matrix = m;
        this.initObject();
    }

    @Override
    public MatrixND getMatrix() {
        return this.matrix;
    }

    protected MatrixFactory getFactory() {
        return MatrixFactory.getInstance();
    }

    public void addMatrixPanelListener(MatrixPanelListener l) {
        this.matrixPanelListeners.add(l);
    }

    public void removeMatrixPanelListener(MatrixPanelListener l) {
        this.matrixPanelListeners.remove(l);
    }

    protected void initObject() {
        if (this.getMatrix() == null) {
            this.editArea.setViewportView(null);
        } else {
            this.popupMenu = new MatrixPopupMenu(this);
            JAXXUtil.assignment((Object)this.popupMenu, (String)"popupMenu", (JAXXObject)this);
            this.table = new JTable(){

                @Override
                public void processMouseEvent(MouseEvent event) {
                    if (event.isPopupTrigger()) {
                        MatrixPanelEditor.this.popupMenu.show(event.getComponent(), event.getX(), event.getY());
                    }
                    super.processMouseEvent(event);
                }
            };
            this.table.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
            this.table.getActionMap().put("copy", this.popupMenu.getSendToClipBoardSelectionCopyAction());
            this.table.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "paste");
            this.table.getActionMap().put("paste", this.popupMenu.getSendToClipBoardCurrentPasteAction());
            if (this.isLinearModel().booleanValue()) {
                this.setTableModel(new MatrixTableModelLinear(this.getMatrix(), this.isLinearModelShowDefault()));
            } else {
                this.setTableModel(new MatrixTableModelND(this.getMatrix()));
            }
            this.getTableModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    MatrixPanelEditor.this.fireEvent();
                }
            });
            this.table.setModel(this.getTableModel());
            this.table.setDefaultRenderer(String.class, this.tableModel.getMatrixCellRenderer());
            this.table.setAutoResizeMode(0);
            this.table.setSelectionMode(1);
            this.editArea.setViewportView(this.table);
        }
        this.repaint();
    }

    protected void btnAction() {
        String dim = JOptionPane.showInputDialog(null, I18n._((String)"nuitonmatrix.create.matrix.message", (Object[])new Object[0]), I18n._((String)"nuitonmatrix.create.matrix.title", (Object[])new Object[0]), -1);
        if (dim != null) {
            String[] sdim = dim.split(";");
            int[] idim = new int[sdim.length];
            for (int i = 0; i < idim.length; ++i) {
                idim[i] = Integer.parseInt(sdim[i]);
            }
            this.setMatrix(this.getFactory().create(idim));
        }
    }

    @Override
    protected void fireEvent() {
        MatrixPanelEvent e = new MatrixPanelEvent(this);
        for (MatrixPanelListener matrixPanelListener : this.matrixPanelListeners) {
            matrixPanelListener.matrixChanged(e);
        }
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public MatrixPanelEditor() {
        this.$initialize();
    }

    public MatrixPanelEditor(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.$bindings.get($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.$bindings.get($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__buttonEdit(ActionEvent event) {
        this.btnAction();
    }

    @Override
    public JButton getButtonEdit() {
        return this.buttonEdit;
    }

    public Boolean getDimensionEdit() {
        return this.dimensionEdit;
    }

    public JScrollPane getEditArea() {
        return this.editArea;
    }

    public Boolean getLinearModel() {
        return this.linearModel;
    }

    public Boolean getLinearModelShowDefault() {
        return this.linearModelShowDefault;
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    public MatrixTableModel getTableModel() {
        return this.tableModel;
    }

    public Boolean isDimensionEdit() {
        return this.dimensionEdit != null && this.dimensionEdit != false;
    }

    @Override
    public Boolean isLinearModel() {
        return this.linearModel != null && this.linearModel != false;
    }

    @Override
    public Boolean isLinearModelShowDefault() {
        return this.linearModelShowDefault != null && this.linearModelShowDefault != false;
    }

    public void setDimensionEdit(Boolean newValue) {
        Boolean oldValue = this.dimensionEdit;
        this.dimensionEdit = newValue;
        this.firePropertyChange(PROPERTY_DIMENSION_EDIT, oldValue, newValue);
    }

    @Override
    public void setLinearModel(Boolean newValue) {
        Boolean oldValue = this.linearModel;
        this.linearModel = newValue;
        this.firePropertyChange(PROPERTY_LINEAR_MODEL, oldValue, newValue);
    }

    @Override
    public void setLinearModelShowDefault(Boolean newValue) {
        Boolean oldValue = this.linearModelShowDefault;
        this.linearModelShowDefault = newValue;
        this.firePropertyChange(PROPERTY_LINEAR_MODEL_SHOW_DEFAULT, oldValue, newValue);
    }

    public void setTableModel(MatrixTableModel newValue) {
        MatrixTableModel oldValue = this.tableModel;
        this.tableModel = newValue;
        this.firePropertyChange(PROPERTY_TABLE_MODEL, oldValue, newValue);
    }

    protected void addChildrenToEditArea() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.editArea.getViewport().add(this.table);
    }

    protected void createButtonEdit() {
        this.buttonEdit = new JButton();
        this.$objectMap.put("buttonEdit", this.buttonEdit);
        this.buttonEdit.setName("buttonEdit");
        this.buttonEdit.setText(I18n._((String)"nuitonmatrix.create.matrix.button", (Object[])new Object[0]));
        this.buttonEdit.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__buttonEdit"));
    }

    protected void createDimensionEdit() {
        this.dimensionEdit = false;
        this.$objectMap.put(PROPERTY_DIMENSION_EDIT, this.dimensionEdit);
    }

    protected void createEditArea() {
        this.editArea = new JScrollPane();
        this.$objectMap.put("editArea", this.editArea);
        this.editArea.setName("editArea");
    }

    protected void createLinearModel() {
        this.linearModel = false;
        this.$objectMap.put(PROPERTY_LINEAR_MODEL, this.linearModel);
    }

    protected void createLinearModelShowDefault() {
        this.linearModelShowDefault = false;
        this.$objectMap.put(PROPERTY_LINEAR_MODEL_SHOW_DEFAULT, this.linearModelShowDefault);
    }

    protected void createTable() {
        this.table = new JTable();
        this.$objectMap.put("table", this.table);
        this.table.setName("table");
    }

    protected void createTableModel() {
        this.tableModel = null;
        this.$objectMap.put(PROPERTY_TABLE_MODEL, null);
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        this.add((Component)this.editArea, "Center");
        this.add((Component)this.buttonEdit, "South");
        this.addChildrenToEditArea();
        JAXXUtil.applyDataBinding((JAXXObject)this, this.$bindings.keySet());
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(1);
    }

    private void $initialize() {
        if (this.allComponentsCreated || !this.contextInitialized) {
            return;
        }
        this.$objectMap.put("$MatrixEditor0", this);
        this.createTableModel();
        this.createLinearModel();
        this.createLinearModelShowDefault();
        this.createDimensionEdit();
        this.matrixPanelListeners = new HashSet<MatrixPanelListener>();
        this.popupMenu = null;
        this.matrix = null;
        this.createEditArea();
        this.createTable();
        this.createButtonEdit();
        this.setName("$MatrixEditor0");
        this.setLayout(new BorderLayout());
        this.initObject();
        this.$registerDefaultBindings();
        this.$completeSetup();
    }

    private void $registerDefaultBindings() {
        this.registerDataBinding((JAXXBinding)new SimpleJAXXObjectBinding(this, BINDING_BUTTON_EDIT_VISIBLE, true, new String[]{PROPERTY_DIMENSION_EDIT}){

            public void processDataBinding() {
                MatrixPanelEditor.this.buttonEdit.setVisible(MatrixPanelEditor.this.isDimensionEdit());
            }
        });
    }
}

