/*
 * #%L
 * 
 * 
 * $Id: MatrixPanelRenderer.java 308 2010-12-09 15:15:08Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-matrix/tags/matrix-2.1/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/renderer/MatrixPanelRenderer.java $
 * %%
 * Copyright (C) 2010 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix.viewer.renderer;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.Icon;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.util.Resource;

/**
 * Matrix panel renderer.
 * 
 * @author chatellier
 * @version $Revision: 308 $
 * 
 * Last update : $Date: 2010-12-09 16:15:08 +0100 (jeu., 09 déc. 2010) $
 * By : $Author: echatellier $
 */
public class MatrixPanelRenderer implements MatrixRenderer {

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getPanel(org.nuiton.math.matrix.MatrixND)
     */
    @Override
    public Component getComponent(MatrixND matrix) {

        MatrixPanelEditor panel = new MatrixPanelEditor();
        panel.setMatrix(matrix);
        return panel;
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getIcon()
     */
    @Override
    public Icon getIcon() {
        return Resource.getIcon("/icons/table.png");
    }

    /*
     * @see org.nuiton.math.matrix.viewer.MatrixRenderer#getName()
     */
    @Override
    public String getName() {
        return _("nuitonmatrix.viewer.renderer.panel");
    }

    
}
