/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceException;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.ModelHelper;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.plugin.AbstractPlugin;

public abstract class AbstractRedmineMojo
extends AbstractPlugin
implements RestClientConfiguration {
    public static final String REDMINE_SYSTEM = "redmine";
    protected MavenProject project;
    protected URL url;
    protected String username;
    protected String password;
    protected String encoding;
    protected String projectId;
    protected String versionId;
    protected boolean verbose;
    protected boolean safe;
    protected MavenSession session;
    protected RedmineService service;
    private final boolean requireProject;
    private final boolean requireVersion;
    private final boolean requireUser;
    protected Project releaseProject;
    protected Version releaseVersion;
    protected User releaseUser;
    protected User[] users;
    protected DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean runOnceDone;

    public AbstractRedmineMojo(boolean requireProject, boolean requireVersion, boolean requireUser) {
        this.requireProject = requireProject;
        this.requireVersion = requireVersion;
        this.requireUser = requireUser;
    }

    protected boolean init() throws Exception {
        boolean r;
        IssueManagement issueManagement = this.project.getIssueManagement();
        if (issueManagement == null) {
            this.getLog().error((CharSequence)"No Issue Management set.");
            return false;
        }
        if (issueManagement.getUrl() == null || issueManagement.getUrl().trim().equals("")) {
            this.getLog().error((CharSequence)"No URL set in Issue Management.");
            return false;
        }
        if (issueManagement.getSystem() != null && !issueManagement.getSystem().equalsIgnoreCase(REDMINE_SYSTEM)) {
            this.getLog().error((CharSequence)"Redmine's Plugin only supports 'redmine' Issue Management system.");
            return false;
        }
        URL url = this.getRestUrl();
        if (url == null || url.toString().isEmpty()) {
            url = new URL(issueManagement.getUrl());
            if (this.verbose) {
                this.getLog().info((CharSequence)("use the url from issue management : " + url));
            }
        }
        this.setRestUrl(url);
        if (this.verbose) {
            this.getLog().info((CharSequence)("Redmine configuration :\n>> host     : " + this.getRestUrl() + "\n>> username : " + this.getRestUsername()));
        }
        try {
            ((RedmineServiceImplementor)this.service).init((RestClientConfiguration)this);
        }
        catch (Exception e) {
            if (this.verbose) {
                this.getLog().error((CharSequence)("could not init Redmine service [" + this.getRestUrl() + "] with user '" + this.getRestUsername() + "'"), (Throwable)e);
            }
            return false;
        }
        if (this.requireProject && !(r = this.initReleaseProject())) {
            this.getLog().error((CharSequence)("the project '" + this.projectId + "' could not be retrieve from redmine server, goal is skip"));
            return false;
        }
        if (this.requireUser && !(r = this.initReleaseUser())) {
            this.getLog().error((CharSequence)("the user '" + this.username + "' could not be retrieve from redmine server, goal is skip"));
            return false;
        }
        if (this.requireVersion && !(r = this.initReleaseVersion())) {
            this.getLog().error((CharSequence)("the version '" + this.versionId + "' could not be retrieve from redmine server, goal is skip"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        boolean canContinue = this.checkPackaging();
        if (!canContinue) {
            this.getLog().warn((CharSequence)("The goal is skip due to packaging '" + this.getProject().getPackaging() + "'"));
            return;
        }
        if (this.isGoalSkip()) {
            this.getLog().warn((CharSequence)"The goal is skip due to skipGoal flag on");
            return;
        }
        Exception error = null;
        try {
            try {
                canContinue = this.init();
            }
            catch (Exception e) {
                error = e;
                canContinue = false;
            }
            if (!canContinue) {
                if (this.isSafe()) {
                    String message = error != null ? "safe mode is on and could not init goal [" + ((Object)((Object)this)).getClass().getSimpleName() + "] for reason " + error.getMessage() : "safe mode is on and could not init goal [" + ((Object)((Object)this)).getClass().getSimpleName() + "]";
                    if (this.isVerbose()) {
                        if (error != null) {
                            this.getLog().error((CharSequence)message, (Throwable)error);
                        } else {
                            this.getLog().error((CharSequence)message);
                        }
                    }
                    if (error != null) {
                        if (error instanceof MojoExecutionException) {
                            throw (MojoExecutionException)((Object)error);
                        }
                        throw new MojoExecutionException(message, error);
                    }
                    throw new MojoExecutionException(message);
                }
                this.getLog().warn((CharSequence)this.skipAfterInitMessage);
                return;
            }
            try {
                this.doAction();
            }
            catch (MojoExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException("could not execute goal " + ((Object)((Object)this)).getClass().getSimpleName() + " for reason : " + e.getMessage(), e);
            }
        }
        finally {
            this.closeService();
        }
    }

    protected abstract void doAction() throws Exception;

    protected abstract boolean isGoalSkip();

    protected abstract boolean isRunOnce();

    protected abstract boolean checkRunOnceDone();

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getRestPassword() {
        return this.password;
    }

    public URL getRestUrl() {
        return this.url;
    }

    public String getRestUsername() {
        return this.username;
    }

    public void setRestPassword(String restPassword) {
        this.password = restPassword;
    }

    public void setRestUrl(URL restUrl) {
        this.url = restUrl;
    }

    public void setRestUsername(String restUsername) {
        this.username = restUsername;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected boolean initReleaseProject() throws MojoExecutionException {
        if (this.projectId == null || this.projectId.trim().isEmpty()) {
            throw new MojoExecutionException("required a projectId parameter");
        }
        try {
            this.releaseProject = this.service.getProject(this.projectId);
            return this.releaseProject != null;
        }
        catch (RedmineServiceException e) {
            this.getLog().warn((CharSequence)("could not retreave project '" + this.projectId + "', goal is skip"));
            if (this.verbose) {
                this.getLog().error((Throwable)e);
            }
            return false;
        }
    }

    protected boolean initReleaseVersion() throws MojoExecutionException {
        if (this.versionId == null || this.versionId.trim().isEmpty()) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        try {
            Version v = this.service.getVersion(this.projectId, this.versionId);
            if (v == null) {
                return false;
            }
            this.releaseVersion = v;
            return true;
        }
        catch (RedmineServiceException e) {
            this.getLog().warn((CharSequence)("could not retreave version " + this.versionId + ", goal is skip"));
            if (this.verbose) {
                this.getLog().error((Throwable)e);
            }
            return false;
        }
    }

    protected boolean initReleaseUser() {
        try {
            this.users = this.service.getUsers(this.projectId);
            User user = ModelHelper.byLogin((String)this.username, (User[])this.users);
            if (user == null) {
                return false;
            }
            this.releaseUser = user;
        }
        catch (RedmineServiceException e) {
            this.getLog().warn((CharSequence)("could not retreave user '" + this.username + "', goal is skip"));
            if (this.verbose) {
                this.getLog().error((Throwable)e);
            }
            return false;
        }
        return true;
    }

    protected void closeService() {
        RedmineServiceImplementor i;
        if (this.service != null && (i = (RedmineServiceImplementor)this.service).isInit()) {
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"<<< Close redmine rest client...");
                }
                i.destroy();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("could not close redmine client for reason " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    public boolean isRunOnceDone() {
        return this.runOnceDone;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }
}

