/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id: RedmineRestClientTest.java 157 2010-10-08 10:23:16Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jredmine/tags/jredmine-1.1.4/jredmine-client/src/test/java/org/nuiton/jredmine/rest/RedmineRestClientTest.java $
 * %%
 * Copyright (C) 2009 - 2010 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.rest;

import org.codehaus.plexus.util.IOUtil;
import org.junit.*;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.jredmine.RedmineTestContract;
import org.nuiton.jredmine.TestHelper;

import java.io.IOException;
import java.io.InputStream;

/**
 * @author chemit
 * @since 1.0.0
 */
public class RedmineRestClientTest implements RedmineTestContract {

    static RestClientConfiguration configuration;
    RedmineRestClient client;

    public RedmineRestClientTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {

        configuration = TestHelper.getTestConfiguration();

        RedmineRestClient client = new RedmineRestClient(configuration);
        try {

            client.open();
        } catch (Exception e) {

            // could not log
            System.out.println("could not connect to server " + configuration.getRestUrl() + ", will skip test " + RedmineRestClientTest.class.getName());
        } finally {
            Assume.assumeTrue(client.isOpen());
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {

        client = new RedmineRestClient(configuration);
        client.open();
    }

    @After
    public void tearDown() throws Exception {

        if (client != null) {
            client.close();
        }
    }

    @Test
    public void isOpen() throws Exception {
        Assert.assertTrue(client.isOpen());
    }

    @Test
    public void isClose() throws Exception {
        Assert.assertTrue(client.isOpen());
        client.close();
        Assert.assertFalse(client.isOpen());
    }

    @Override
    @Test
    public void getProjects() throws Exception {

        doRequest(RedmineRestClient.GET_PROJECT_LIST);
    }

    @Override
    @Test
    public void getIssuePriorities() throws Exception {

        doRequest(RedmineRestClient.GET_ISSUE_PRIORITY_LIST);
    }

    @Override
    @Test
    public void getIssueStatuses() throws Exception {

        doRequest(RedmineRestClient.GET_ISSUE_STATUS_LIST);
    }

    @Override
    @Test
    public void getProject() throws Exception {

        doRequest(RedmineRestClient.GET_PROJECT, PROJECT_NAME);
    }

    @Override
    @Test
    public void getIssueCategories() throws Exception {

        doRequest(RedmineRestClient.GET_ISSUE_CATEGORY_LIST, PROJECT_NAME);
    }

    @Override
    @Test
    public void getTrackers() throws Exception {

        doRequest(RedmineRestClient.GET_TRACKER_LIST, PROJECT_NAME);
    }

    @Override
    @Test
    public void getNews() throws Exception {

        doRequest(RedmineRestClient.GET_NEWS_LIST, PROJECT_NAME);
    }

    @Override
    public void getUserProjects() throws Exception {
        
        doRequest(RedmineRestClient.GET_USER_PROJECTS, PROJECT_NAME);
    }

    @Override
    public void getProjectMembers() throws Exception {

        doRequest(RedmineRestClient.GET_USER_LIST, PROJECT_NAME);
    }

    @Override
    @Test
    public void getProjectIssues() throws Exception {

        doRequest(RedmineRestClient.GET_PROJECT_ISSUES, PROJECT_NAME);
    }

    @Override
    @Test
    public void getVersions() throws Exception {

        doRequest(RedmineRestClient.GET_VERSION_LIST, PROJECT_NAME);
    }

    @Override
    @Test
    public void getVersion() throws Exception {

        doRequest(RedmineRestClient.GET_VERSION, PROJECT_NAME, VERSION_NAME);
    }

    @Override
    @Test
    public void getVersionIssues() throws Exception {

        doRequest(RedmineRestClient.GET_ISSUE_LIST, PROJECT_NAME, VERSION_NAME);
    }

    @Override
    @Test
    public void getOpenedIssues() throws Exception {

        doRequest(RedmineRestClient.GET_PROJECT_OPENED_ISSUES, PROJECT_NAME);
    }

    @Override
    @Test
    public void getClosedIssues() throws Exception {

        doRequest(RedmineRestClient.GET_PROJECT_CLOSED_ISSUES, PROJECT_NAME);
    }

    @Override
    @Test
    public void getIssueTimeEntries() throws Exception {

        doRequest(RedmineRestClient.GET_ISSUE_TIME_ENTRY_LIST, PROJECT_NAME, ISSUE_ID);
    }


    @Override
    @Test
    public void getAttachments() throws Exception {

        doRequest(RedmineRestClient.GET_ATTACHMENTS_LIST, PROJECT_NAME, VERSION_NAME);
    }

    @Override
    @Test
    public void addVersion() throws Exception {
        //TODO
    }

    @Override
    @Test
    public void addAttachment() throws Exception {
        //TODO
    }

    @Override
    @Test
    public void addNews() throws Exception {
        //TODO
    }

    @Override
    @Test
    public void updateVersion() throws Exception {
        //TODO
    }

    @Override
    @Test
    public void nextVersion() throws Exception {
        //TODO
    }

    @Override
    @Test
    public void addIssueTime() throws Exception {
        //TODO
    }

    protected void doRequest(String requestId, Object... params) throws IOException, RestException {

        RestRequest request;
        InputStream askData;
        String toString;

        request = client.getRequest(requestId, params);
        askData = client.askData(request);
        toString = IOUtil.toString(askData);
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
    }
}
