/*
 * *##% 
 * JRedmine :: Client
 * Copyright (C) 2009 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.jredmine;

import org.junit.Test;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.TimeEntry;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

/**
 * Created: 2 janv. 2010
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 122 $
 *          <p/>
 *          Mise a jour: $Date: 2010-01-24 19:51:06 +0100 (dim., 24 janv. 2010) $ par :
 *          $Author: tchemit $
 */
public class DefaultRedmineServiceAsAnonymousTest extends AbstractRedmineServiceTest<DefaultRedmineService> {

    public DefaultRedmineServiceAsAnonymousTest() {
        super(DefaultRedmineService.class);
    }

    @Override
    protected RedmineRestClient newClient(RestClientConfiguration configuration) {
        configuration.setAnonymous(true);
        return super.newClient(configuration);
    }

    @Test(expected = RedmineServiceLoginException.class)
    @Override
    public void getUserProjects() throws Exception {
        projects = getService().getUserProjects();
    }

    @Test(expected = RedmineServiceLoginException.class)
    @Override
    public void addVersion() throws Exception {
        version = new Version();
        getService().addVersion(PROJECT_NAME, version);
    }

    @Test(expected = RedmineServiceLoginException.class)
    @Override
    public void addAttachment() throws Exception {
        attachment = new Attachment();
        getService().addAttachment(PROJECT_NAME, VERSION_NAME, attachment);
    }

    @Test(expected = RedmineServiceLoginException.class)
    @Override
    public void addNews() throws Exception {
        newz = new News();
        getService().addNews(PROJECT_NAME, newz);
    }

    @Test(expected = RedmineServiceLoginException.class)
    @Override
    public void updateVersion() throws Exception {
        version = new Version();
        getService().updateVersion(PROJECT_NAME, version);
    }

    @Test(expected = RedmineServiceLoginException.class)
    @Override
    public void nextVersion() throws Exception {

        version = new Version();
        getService().nextVersion(PROJECT_NAME, VERSION_NAME, version);
    }

    @Test(expected = RedmineServiceLoginException.class)
    @Override
    public void addIssueTime() throws Exception {
        timeEntry = new TimeEntry();
        getService().addIssueTimeEntry(PROJECT_NAME, ISSUE_ID, timeEntry);
    }

}