/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.templates;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.jpa.templates.JpaTemplatesGeneratorUtil;

public abstract class AbstractJpaTransformer
extends ObjectModelTransformerToJava {
    public static final String DEFAULT_CONSTANT_PREFIX = "PROPERTY_";

    protected void addConstructorWithEntityManager(ObjectModelClass output) {
        ObjectModelOperation constructor = this.addConstructor(output, (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        this.addParameter(constructor, EntityManager.class, "entityManager");
        this.setOperationBody(constructor, "\n        super(entityManager);\n    ");
    }

    protected boolean isSuperClassEntity(ObjectModelClass input) {
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (!input.getPackageName().equals(superclass.getPackageName())) continue;
                superClassIsBean = true;
                break;
            }
        }
        return superClassIsBean;
    }

    protected boolean isEntity(ObjectModelClass input, String type) {
        ObjectModelClass aClass = ((ObjectModel)this.getModel()).getClass(type);
        boolean result = aClass != null && input.getPackageName().equals(aClass.getPackageName());
        return result;
    }

    protected void createPropertyConstant(ObjectModelClass output, ObjectModelAttribute attr, String prefix, Set<String> constantNames) {
        String attrName = JpaTemplatesGeneratorUtil.getAttributeName(attr);
        String constantName = prefix + this.builder.getConstantName(attrName);
        if (!constantNames.contains(constantName)) {
            this.addConstant((ObjectModelClassifier)output, constantName, String.class, "\"" + attrName + "\"", (ObjectModelModifier)ObjectModelJavaModifier.PUBLIC);
        }
    }

    protected void addSerializable(ObjectModelClass input, ObjectModelClass output, boolean interfaceFound) {
        if (!interfaceFound) {
            this.addInterface((ObjectModelClassifier)output, Serializable.class);
        }
        long serialVersionUID = JpaTemplatesGeneratorUtil.generateSerialVersionUID((ObjectModelClassifier)input);
        this.addConstant((ObjectModelClassifier)output, "serialVersionUID", "long", serialVersionUID + "L", (ObjectModelModifier)ObjectModelJavaModifier.PRIVATE);
    }

    protected boolean addInterfaces(ObjectModelClass input, ObjectModelClass output) {
        boolean foundSerializable = false;
        for (ObjectModelInterface parentInterface : input.getInterfaces()) {
            String fqn = parentInterface.getQualifiedName();
            this.addInterface((ObjectModelClassifier)output, fqn);
            if (!Serializable.class.getName().equals(fqn)) continue;
            foundSerializable = true;
        }
        return foundSerializable;
    }
}

