package org.nuiton.jaxx.runtime.swing;

/*-
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.model.GenericListListener;
import org.nuiton.jaxx.runtime.swing.model.GenericListModel;

public abstract class ListSelector<B> extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_TOOL_TIP = "addToolTip";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_REMOVE_TOOL_TIP = "removeToolTip";
    public static final String PROPERTY_RENDERER = "renderer";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ2Sv04CQRDGh4uAwWCMtR3GGP/saU1loDKnJkBBQrVwEzyyd3vuDnA2FBY+hC9gY3wSn4B3MPER3D2Qo+ASdcvZb37zze739glFreBMqiGLxgHJiI14kjA1jigIkV1fdbt3/REOqIl6oIKYpILFKTjg9GDHX9U1Aet5huQuSK4luUuS25BhLCOM1kB1DyqaHgXqe0QiOM5tHmjttlfKehKP1XLWRtebZn08X84L2HxxAJLY2Ldrn/4BkG295YET+AT73ohPuCt4NDTmVBANzUJVW2sIrvUtD/EBZlD2oBRzZWAE5/96nhSXopKYoHzY4X2BFwQnefb11JhhXqCpjcL8nVRxnAJKBBXu+x0pRcfMgD3rltkN2GKDTFdVGMoJLqW2uJtdFkPpoyBwf+/gxnZkhG3zID4qVAQH1kSy1tJAIVrLa9Oh4ChvjMkFy3KRfVGhB0U1NmWCWn4kbapaRrXIUy0/T3ZMKnx6n6nX6df8J0TwDZ3nS9BAAwAA";
    private static final Log log = LogFactory.getLog(ListSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected String addToolTip;
    protected ListSelectorModel<B> model;
    protected String removeToolTip;
    protected ListCellRenderer renderer;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ListSelector<B> $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setValues(Collection<B> values) {
        model.setValues(values);
    }
    
    public Collection<B> getValues() {
        return model.getValues();
    }
    
    public void setSelectedValues(Collection<B> selectedValues) {
        model.setSelectedValues(selectedValues);
    }
    
    public Collection<B> getSelectedValues() {
        return model.getSelectedValues();
    }
    
    public void addGenericListListener(GenericListListener l) {
        model.addGenericListListener(l);
    }
    
    public void removeGenericListListener(GenericListListener l) {
        model.removeGenericListListener(l);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ListSelector() {
        $initialize();
    }

    public ListSelector(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public String getAddToolTip() {
        return addToolTip;
    }

    public ListSelectorModel<B> getModel() {
        return model;
    }

    public String getRemoveToolTip() {
        return removeToolTip;
    }

    public ListCellRenderer getRenderer() {
        return renderer;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddToolTip(String addToolTip) {
        String oldValue = this.addToolTip;
        this.addToolTip = addToolTip;
        firePropertyChange(PROPERTY_ADD_TOOL_TIP, oldValue, addToolTip);
    }

    public void setModel(ListSelectorModel<B> model) {
        ListSelectorModel<B> oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    public void setRemoveToolTip(String removeToolTip) {
        String oldValue = this.removeToolTip;
        this.removeToolTip = removeToolTip;
        firePropertyChange(PROPERTY_REMOVE_TOOL_TIP, oldValue, removeToolTip);
    }

    public void setRenderer(ListCellRenderer renderer) {
        ListCellRenderer oldValue = this.renderer;
        this.renderer = renderer;
        firePropertyChange(PROPERTY_RENDERER, oldValue, renderer);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddToolTip() {
        $objectMap.put("addToolTip", addToolTip = "+");
    }

    protected void createModel() {
        $objectMap.put("model", model = null);
    }

    protected void createRemoveToolTip() {
        $objectMap.put("removeToolTip", removeToolTip = "-");
    }

    protected void createRenderer() {
        $objectMap.put("renderer", renderer = new DefaultListCellRenderer());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createAddToolTip();
        createRemoveToolTip();
        createModel();
        createRenderer();
        // inline creation of $Table0
        setName("$Table0");
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}