/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: CallBackEntry.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5/jaxx-widgets/src/main/java/jaxx/runtime/swing/editor/config/model/CallBackEntry.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor.config.model;

import javax.swing.*;
import java.util.ArrayList;
import java.util.List;

/**
 * A call back with his attached options.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class CallBackEntry {

    protected final String name;
    protected final String description;
    protected final Icon icon;
    protected final Runnable action;
    protected List<OptionModel> options;

    public CallBackEntry(String name,
                         String description,
                         Icon icon,
                         Runnable action) {
        this.description = description;
        this.icon = icon;
        options = new ArrayList<OptionModel>();
        this.name = name;
        this.action = action;
    }

    public Runnable getAction() {
        return action;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public Icon getIcon() {
        return icon;
    }

    public List<OptionModel> getOptions() {
        // always send a copy
        return new ArrayList<OptionModel>(options);
    }

    protected void addOption(OptionModel option) {
        options.add(option);

    }
}
