/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id: JAXXLog4jAppender.java 2455 2012-07-30 18:47:43Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.6/jaxx-widgets/src/main/java/jaxx/runtime/swing/log/JAXXLog4jAppender.java $
 * %%
 * Copyright (C) 2008 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.log;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class JAXXLog4jAppender extends WriterAppender {

    public static final String PROPERTY_LOGS = "logs";
    public static final String PROPERTY_LEVEL = "level";

    protected List<LoggingEvent> events;
    protected StringBuilder logs;
    protected Level level;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public JAXXLog4jAppender() {
        events = new LinkedList<LoggingEvent>();
        logs = new StringBuilder();
    }

    public String getLogs() {
        return logs.toString();
    }

    public void setLogs(String logs) {
        String oldValue = getLogs();
        this.logs = new StringBuilder(logs);
        firePropertyChange(PROPERTY_LOGS, oldValue, logs);
    }

    public Level getLevel() {
        if (level == null) {
            level = Level.ALL;
        }
        return level;
    }

    public void setLevel(Level level) {
        Level oldValue = getLevel();
        this.level = level;
        firePropertyChange(PROPERTY_LEVEL, oldValue, level);
        updateLogs();
    }

    @Override
    public void append(LoggingEvent event) {
        super.append(event);
        if (event != null) {
            events.add(event);
            updateLog(event);
        }
    }

    protected void updateLogs() {
        String oldValue = getLogs();
        logs = new StringBuilder();
        for (LoggingEvent event : events) {
            updateLog(event);
        }
        firePropertyChange(PROPERTY_LOGS, oldValue, getLogs());
    }

    protected void updateLog(LoggingEvent event) {
        Level level = event.getLevel();
        if (getLevel() != null && level.isGreaterOrEqual(getLevel())) {
            String log = this.layout.format(event);
            appendLog(log);
            if(layout.ignoresThrowable()) {
                String[] errorLogs = event.getThrowableStrRep();
                if (errorLogs != null) {
                    for (String errorLog : errorLogs) {
                        appendLog(errorLog + "\n");
                    }
                }
            }
        }
    }

    protected void appendLog(String log) {
        String oldValue = getLogs();
        logs.append(log);
        firePropertyChange(PROPERTY_LOGS, oldValue, getLogs());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }
}
