package jaxx.runtime.swing.editor;

/*
 * #%L
 * JAXX :: Widgets
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.css.DataBinding;
import jaxx.runtime.css.Pseudoclasses;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class NumberEditor2 extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_RESET_TIP = "showResetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_PAD_TOUCH_SIGN_ENABLED = "padTouchSign.enabled";
    public static final String BINDING_RESET_BUTTON_ENABLED = "resetButton.enabled";
    public static final String BINDING_RESET_BUTTON_TOOL_TIP_TEXT = "resetButton.toolTipText";
    public static final String BINDING_SHOW_POP_UP_BUTTON_ENABLED = "showPopUpButton.enabled";
    public static final String BINDING_SHOW_POP_UP_BUTTON_VISIBLE = "showPopUpButton.visible";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXTU8bRxgeO9h8GBoChYJCFNpUKpVgAfMtojThS4AgiTBpo9JDxt7BHrre2czOgilq1Z/Qn9Dee6nUW09VDz330EvVv1BFPfRa9Z3ZtXcXr9eLi8AyM88878fMPO873/+FMjZH757hWk3jjilolWj7T16+fFY8IyWxRewSp5ZgHLk/qTRKn6Cc3hi3BXpwciCXz3rLZzdZ1WImMQOr1w9Qny0uDWJXCBEC3QuvKNn2bKExvV6zHF5nbTgVxfrt32/S3+hff5dGqGaBd3chlMl2q/xIug5QmuoCDYGlczxrYLMMbnBqlsHfATm2aWDbfoqr5DX6CnUfoKyFOZAJ9F7ykBWHWl+zBMoRncLsc2wSQ6APQs7aF2BacwHaU6daJHxb/ZO3LMWQFajXrrCLI2LLLN6RLmrSbW2DMYNg08f1N3DH4A4a9KFuhD4yU2W69GU6oS+HEh5YbjHLAQuj0kLNW7f/XA4eEtPxgX0K6AU+FEbLQQkb8eO0sH7MnFJlRaDhEHjDEYKZEjYG1nVapqJp0aocuBePWWuNGaxjNiGp/IlhhKAlOdhEt5jA5FICzHJSt56ZJIFb8wlM5hNgFmIw73t7MudjmvdxrjVBfx1ToGUzCOthFuFYqoyHzNWRW0y0BX6MDapjQSK8ygm4L0XMD8gp3KO3Q+frGKY2MJfIXn8Bl1fJP3qKb78xnXUvikD3Q1Q7jFexEEQ/JjWxQ4mhh1n7PTeOaLmi4jkIz9+Wlxiu0gvLtSzQ+DVXy2WD+F4dWSCAd0P3GKRV86XV177UCcpwB4YFGjtpVuMjmHJ1eOyaDktCNfvv6PDvP/35405dfO+D7ZFIaKB2gChaXG6WoNL0bVd5HUGN2UNsrZ+AvhEDCo8qLBMRjhW8aXAO7LkKKJdru9iuAEWm+4+ffxl99dstlN5BfQbD+g6W+D3UKyqwiRVm6DXro8fKo/6LHvgchL9bcFJPAS1w0YA0ZU6xAfuNsszCr53AwECRcZ2AfFMTtrU+XoM8TUTkqeFssffXf4YLPzyu5yoFvo+3hPv5ynyKstQ0qElUqfKqUGRpylk2cXTmV5uo+oNAqHvqJ9yT5s/U56volLCSY4dT0q/GriVAQU0xY9Mv4Ht6frHmSNKKClV+O5OWuz2daGM4BbXilHFS5swxwURX0XBIPGFIUZLydj+Ym1tbm5trRx0Wl6TstzjR2zrta3YMbfc5tanag5ErVas1ahfq1X3qwy+brYQFzmqT7wyYIKbcZXB74Ira2+4/QH2jI9AHF40yc68khWrIVD2Dq4sz3G1YlFfQj0g5BC3zoikTUQg0K60iCihwu4hSrSOKovbUOwFrroprtOpUC+qcj16Z5GJyC66vaUPgU/nF6fxitImQ0rcz1BW3Ia1Og+q4FCK0D++E9qGEjZJjYFWqwpsxEcRpLoMmy48mqBUV0fXa1C6oNDhWxKXP6/dj4GqTGWDqk929423wOusqq0AzVxvqm6vbl1qJEyji21VLXLoTU4vTk95vdLIDnWaCPe0SKgFvhRIQIQrBXqZT2vlY2vlOafOxtPlOaRdiaRc6pY0oDsE+ulPapVjapU5pl2NplzulXYmlXemUdjWWdrVT2rVY2rXktIMhWp2JSKkPdPkJZMXXyuGGIr6wiXxMKD30TN8JmbZhNlKog2+R5HGNhMhlWTfhfRZloOkR97+MwNu0vREAJTASKhshUzPn3kuq1WbVX1pJKqjqEy+IrIOytZPteFyXBMesyhybsHPCb0ieNeXzKyI/Lehv0OllDXzJHHlNHkLceLJITR1eZI+abKXkZ1/bvMBwald+7EUzjN+o4xl66L4ZJuHtyWnREaSFY4+A9j+d2TVDAhQAAA==";
    private static final Log log = LogFactory.getLog(NumberEditor2.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JFormattedTextField editor;
    protected NumberEditor2 editorPanel = this;
    protected final NumberEditor2Handler handler = new NumberEditor2Handler();
    protected NumberEditor2Model model;
    protected JButton padTouch0;
    protected JButton padTouch1;
    protected JButton padTouch2;
    protected JButton padTouch3;
    protected JButton padTouch4;
    protected JButton padTouch5;
    protected JButton padTouch6;
    protected JButton padTouch7;
    protected JButton padTouch8;
    protected JButton padTouch9;
    protected JButton padTouchClearAll;
    protected JButton padTouchClearOne;
    protected JButton padTouchDot;
    protected JButton padTouchSign;
    protected JButton padValidate;
    protected JPopupMenu popup;
    protected JPanel popupPanel;
    protected JButton resetButton;
    protected JToggleButton showPopUpButton;
    protected Boolean showReset;
    protected String showResetTip;
    protected JToolBar toolbarLeft;
    protected JToolBar toolbarRight;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(); }
    public void setBean(Serializable bean) { model.setBean(bean); }
    public void setBeanProperty(String beanProperty) { model.setBeanProperty(beanProperty); }
    public void setValue(Number value) { handler.setValue(value, true); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor2(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumberEditor2(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor2() {
        $initialize();
    }

    public NumberEditor2(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor2(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor2(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NumberEditor2(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumberEditor2(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__padTouch0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch6(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch7(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch8(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouch9(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouchClearAll(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setModel(null);
    }

    public void doActionPerformed__on__padTouchClearOne(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeChar();
    }

    public void doActionPerformed__on__padTouchDot(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addChar(event);
    }

    public void doActionPerformed__on__padTouchSign(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.toggleSign();
    }

    public void doActionPerformed__on__padValidate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.validate();
    }

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.resetEditor();
    }

    public void doActionPerformed__on__showPopUpButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setPopupVisible(!popup.isVisible());
    }

    public void doFocusGained__on__editorPanel(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        editor.requestFocus();
    }

    public void doFocusLost__on__editorPanel(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setPopupVisible(false);popup.setVisible(false);
    }

    public void doKeyReleased__on__editor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onKeyReleased(event);
    }

    public void doMouseEntered__on__$JButton0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, $JButton0, "font-weight", "bold", Pseudoclasses.wrap(($JButton0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton0.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch0, "font-weight", "bold", Pseudoclasses.wrap((padTouch0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch0.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch0.setFont(padTouch0.getFont().deriveFont(padTouch0.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch0.setFont(padTouch0.getFont().deriveFont(padTouch0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch1(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch1, "font-weight", "bold", Pseudoclasses.wrap((padTouch1.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch1.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch1.setFont(padTouch1.getFont().deriveFont(padTouch1.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch1.setFont(padTouch1.getFont().deriveFont(padTouch1.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch2(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch2, "font-weight", "bold", Pseudoclasses.wrap((padTouch2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch2.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch2.setFont(padTouch2.getFont().deriveFont(padTouch2.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch2.setFont(padTouch2.getFont().deriveFont(padTouch2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch3(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch3, "font-weight", "bold", Pseudoclasses.wrap((padTouch3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch3.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch3.setFont(padTouch3.getFont().deriveFont(padTouch3.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch3.setFont(padTouch3.getFont().deriveFont(padTouch3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch4(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch4, "font-weight", "bold", Pseudoclasses.wrap((padTouch4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch4.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch4.setFont(padTouch4.getFont().deriveFont(padTouch4.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch4.setFont(padTouch4.getFont().deriveFont(padTouch4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch5(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch5, "font-weight", "bold", Pseudoclasses.wrap((padTouch5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch5.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch5.setFont(padTouch5.getFont().deriveFont(padTouch5.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch5.setFont(padTouch5.getFont().deriveFont(padTouch5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch6(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch6, "font-weight", "bold", Pseudoclasses.wrap((padTouch6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch6.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch6.setFont(padTouch6.getFont().deriveFont(padTouch6.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch6.setFont(padTouch6.getFont().deriveFont(padTouch6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch7(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch7, "font-weight", "bold", Pseudoclasses.wrap((padTouch7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch7.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch7.setFont(padTouch7.getFont().deriveFont(padTouch7.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch7.setFont(padTouch7.getFont().deriveFont(padTouch7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch8(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch8, "font-weight", "bold", Pseudoclasses.wrap((padTouch8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch8.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch8.setFont(padTouch8.getFont().deriveFont(padTouch8.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch8.setFont(padTouch8.getFont().deriveFont(padTouch8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouch9(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouch9, "font-weight", "bold", Pseudoclasses.wrap((padTouch9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch9.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch9.setFont(padTouch9.getFont().deriveFont(padTouch9.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch9.setFont(padTouch9.getFont().deriveFont(padTouch9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouchClearAll(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouchClearAll, "font-weight", "bold", Pseudoclasses.wrap((padTouchClearAll.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchClearAll.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchClearAll.setFont(padTouchClearAll.getFont().deriveFont(padTouchClearAll.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchClearAll.setFont(padTouchClearAll.getFont().deriveFont(padTouchClearAll.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouchClearOne(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouchClearOne, "font-weight", "bold", Pseudoclasses.wrap((padTouchClearOne.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchClearOne.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchClearOne.setFont(padTouchClearOne.getFont().deriveFont(padTouchClearOne.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchClearOne.setFont(padTouchClearOne.getFont().deriveFont(padTouchClearOne.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouchDot(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouchDot, "font-weight", "normal", Pseudoclasses.wrap((padTouchDot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchDot.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchDot.setFont(padTouchDot.getFont().deriveFont(padTouchDot.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchDot.setFont(padTouchDot.getFont().deriveFont(padTouchDot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padTouchSign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padTouchSign, "font-weight", "normal", Pseudoclasses.wrap((padTouchSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchSign.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchSign.setFont(padTouchSign.getFont().deriveFont(padTouchSign.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchSign.setFont(padTouchSign.getFont().deriveFont(padTouchSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__padValidate(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, padValidate, "font-weight", "bold", Pseudoclasses.wrap((padValidate.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padValidate.getFont() != null) {
            if (((String) value).equals("bold")) {
                padValidate.setFont(padValidate.getFont().deriveFont(padValidate.getFont().getStyle() | Font.BOLD));
            } else {
                padValidate.setFont(padValidate.getFont().deriveFont(padValidate.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseEntered__on__resetButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.applyProperty(NumberEditor2.this, resetButton, "font-weight", "bold", Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__$JButton0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, $JButton0, "font-weight", "bold", Pseudoclasses.wrap(($JButton0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if ($JButton0.getFont() != null) {
            if (((String) value).equals("bold")) {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() | Font.BOLD));
            } else {
                $JButton0.setFont($JButton0.getFont().deriveFont($JButton0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__editorPanel(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setPopupVisible(false);popup.setVisible(false);
    }

    public void doMouseExited__on__padTouch0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch0, "font-weight", "bold", Pseudoclasses.wrap((padTouch0.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch0.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch0.setFont(padTouch0.getFont().deriveFont(padTouch0.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch0.setFont(padTouch0.getFont().deriveFont(padTouch0.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch1(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch1, "font-weight", "bold", Pseudoclasses.wrap((padTouch1.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch1.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch1.setFont(padTouch1.getFont().deriveFont(padTouch1.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch1.setFont(padTouch1.getFont().deriveFont(padTouch1.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch2(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch2, "font-weight", "bold", Pseudoclasses.wrap((padTouch2.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch2.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch2.setFont(padTouch2.getFont().deriveFont(padTouch2.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch2.setFont(padTouch2.getFont().deriveFont(padTouch2.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch3(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch3, "font-weight", "bold", Pseudoclasses.wrap((padTouch3.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch3.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch3.setFont(padTouch3.getFont().deriveFont(padTouch3.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch3.setFont(padTouch3.getFont().deriveFont(padTouch3.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch4(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch4, "font-weight", "bold", Pseudoclasses.wrap((padTouch4.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch4.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch4.setFont(padTouch4.getFont().deriveFont(padTouch4.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch4.setFont(padTouch4.getFont().deriveFont(padTouch4.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch5(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch5, "font-weight", "bold", Pseudoclasses.wrap((padTouch5.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch5.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch5.setFont(padTouch5.getFont().deriveFont(padTouch5.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch5.setFont(padTouch5.getFont().deriveFont(padTouch5.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch6(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch6, "font-weight", "bold", Pseudoclasses.wrap((padTouch6.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch6.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch6.setFont(padTouch6.getFont().deriveFont(padTouch6.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch6.setFont(padTouch6.getFont().deriveFont(padTouch6.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch7(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch7, "font-weight", "bold", Pseudoclasses.wrap((padTouch7.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch7.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch7.setFont(padTouch7.getFont().deriveFont(padTouch7.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch7.setFont(padTouch7.getFont().deriveFont(padTouch7.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch8(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch8, "font-weight", "bold", Pseudoclasses.wrap((padTouch8.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch8.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch8.setFont(padTouch8.getFont().deriveFont(padTouch8.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch8.setFont(padTouch8.getFont().deriveFont(padTouch8.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouch9(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouch9, "font-weight", "bold", Pseudoclasses.wrap((padTouch9.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouch9.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouch9.setFont(padTouch9.getFont().deriveFont(padTouch9.getFont().getStyle() | Font.BOLD));
            } else {
                padTouch9.setFont(padTouch9.getFont().deriveFont(padTouch9.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouchClearAll(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouchClearAll, "font-weight", "bold", Pseudoclasses.wrap((padTouchClearAll.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchClearAll.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchClearAll.setFont(padTouchClearAll.getFont().deriveFont(padTouchClearAll.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchClearAll.setFont(padTouchClearAll.getFont().deriveFont(padTouchClearAll.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouchClearOne(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouchClearOne, "font-weight", "bold", Pseudoclasses.wrap((padTouchClearOne.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchClearOne.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchClearOne.setFont(padTouchClearOne.getFont().deriveFont(padTouchClearOne.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchClearOne.setFont(padTouchClearOne.getFont().deriveFont(padTouchClearOne.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouchDot(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouchDot, "font-weight", "normal", Pseudoclasses.wrap((padTouchDot.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchDot.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchDot.setFont(padTouchDot.getFont().deriveFont(padTouchDot.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchDot.setFont(padTouchDot.getFont().deriveFont(padTouchDot.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padTouchSign(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padTouchSign, "font-weight", "normal", Pseudoclasses.wrap((padTouchSign.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padTouchSign.getFont() != null) {
            if (((String) value).equals("bold")) {
                padTouchSign.setFont(padTouchSign.getFont().deriveFont(padTouchSign.getFont().getStyle() | Font.BOLD));
            } else {
                padTouchSign.setFont(padTouchSign.getFont().deriveFont(padTouchSign.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__padValidate(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, padValidate, "font-weight", "bold", Pseudoclasses.wrap((padValidate.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (padValidate.getFont() != null) {
            if (((String) value).equals("bold")) {
                padValidate.setFont(padValidate.getFont().deriveFont(padValidate.getFont().getStyle() | Font.BOLD));
            } else {
                padValidate.setFont(padValidate.getFont().deriveFont(padValidate.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doMouseExited__on__resetButton(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        Object value = Pseudoclasses.removeProperty(NumberEditor2.this, resetButton, "font-weight", "bold", Pseudoclasses.wrap((resetButton.getFont().getStyle() & Font.BOLD) != 0 ? "bold" : "normal"), 0);
        if (!(value instanceof DataBinding)) {
            if (resetButton.getFont() != null) {
            if (((String) value).equals("bold")) {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() | Font.BOLD));
            } else {
                resetButton.setFont(resetButton.getFont().deriveFont(resetButton.getFont().getStyle() & ~Font.BOLD));
            }
        }
        }
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(false);
    }

    public void doPopupMenuWillBecomeVisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        showPopUpButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JFormattedTextField getEditor() {
        return editor;
    }

    public NumberEditor2Handler getHandler() {
        return handler;
    }

    public NumberEditor2Model getModel() {
        return model;
    }

    public JButton getPadTouch0() {
        return padTouch0;
    }

    public JButton getPadTouch1() {
        return padTouch1;
    }

    public JButton getPadTouch2() {
        return padTouch2;
    }

    public JButton getPadTouch3() {
        return padTouch3;
    }

    public JButton getPadTouch4() {
        return padTouch4;
    }

    public JButton getPadTouch5() {
        return padTouch5;
    }

    public JButton getPadTouch6() {
        return padTouch6;
    }

    public JButton getPadTouch7() {
        return padTouch7;
    }

    public JButton getPadTouch8() {
        return padTouch8;
    }

    public JButton getPadTouch9() {
        return padTouch9;
    }

    public JButton getPadTouchClearAll() {
        return padTouchClearAll;
    }

    public JButton getPadTouchClearOne() {
        return padTouchClearOne;
    }

    public JButton getPadTouchDot() {
        return padTouchDot;
    }

    public JButton getPadTouchSign() {
        return padTouchSign;
    }

    public JButton getPadValidate() {
        return padValidate;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JPanel getPopupPanel() {
        return popupPanel;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public JToggleButton getShowPopUpButton() {
        return showPopUpButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public String getShowResetTip() {
        return showResetTip;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JToolBar getToolbarRight() {
        return toolbarRight;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowResetTip(String showResetTip) {
        String oldValue = this.showResetTip;
        this.showResetTip = showResetTip;
        firePropertyChange(PROPERTY_SHOW_RESET_TIP, oldValue, showResetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(toolbarLeft, BorderLayout.WEST);
        add(editor, BorderLayout.CENTER);
        add(toolbarRight, BorderLayout.EAST);
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupPanel);
    }

    protected void addChildrenToPopupPanel() {
        if (!allComponentsCreated) {
            return;
        }
        popupPanel.add(padTouch7);
        popupPanel.add(padTouch8);
        popupPanel.add(padTouch9);
        popupPanel.add(padTouchClearAll);
        popupPanel.add(padTouch4);
        popupPanel.add(padTouch5);
        popupPanel.add(padTouch6);
        popupPanel.add(padTouchClearOne);
        popupPanel.add(padTouch1);
        popupPanel.add(padTouch2);
        popupPanel.add(padTouch3);
        popupPanel.add($JButton0);
        popupPanel.add(padTouch0);
        popupPanel.add(padTouchSign);
        popupPanel.add(padTouchDot);
        popupPanel.add(padValidate);
    }

    protected void addChildrenToToolbarLeft() {
        if (!allComponentsCreated) {
            return;
        }
        toolbarLeft.add(resetButton);
    }

    protected void addChildrenToToolbarRight() {
        if (!allComponentsCreated) {
            return;
        }
        toolbarRight.add(showPopUpButton);
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setEnabled(false);
        $JButton0.setFocusable(false);
        $JButton0.setFocusPainted(false);
        if ($JButton0.getFont() != null) {
            $JButton0.setFont($JButton0.getFont().deriveFont((float) 14));
        }
        $JButton0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__$JButton0"));
        $JButton0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__$JButton0"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JFormattedTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    protected void createModel() {
        $objectMap.put("model", model = new NumberEditor2Model());
    }

    protected void createPadTouch0() {
        $objectMap.put("padTouch0", padTouch0 = new JButton());
        
        padTouch0.setName("padTouch0");
        padTouch0.setFocusable(false);
        padTouch0.setText(t("numbereditor.0"));
        padTouch0.setFocusPainted(false);
        if (padTouch0.getFont() != null) {
            padTouch0.setFont(padTouch0.getFont().deriveFont((float) 14));
        }
        padTouch0.setForeground(new Color(0, 0, 255));
        padTouch0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch0"));
        padTouch0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch0"));
        padTouch0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch0"));
    }

    protected void createPadTouch1() {
        $objectMap.put("padTouch1", padTouch1 = new JButton());
        
        padTouch1.setName("padTouch1");
        padTouch1.setFocusable(false);
        padTouch1.setText(t("numbereditor.1"));
        padTouch1.setFocusPainted(false);
        if (padTouch1.getFont() != null) {
            padTouch1.setFont(padTouch1.getFont().deriveFont((float) 14));
        }
        padTouch1.setForeground(new Color(0, 0, 255));
        padTouch1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch1"));
        padTouch1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch1"));
        padTouch1.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch1"));
    }

    protected void createPadTouch2() {
        $objectMap.put("padTouch2", padTouch2 = new JButton());
        
        padTouch2.setName("padTouch2");
        padTouch2.setFocusable(false);
        padTouch2.setText(t("numbereditor.2"));
        padTouch2.setFocusPainted(false);
        if (padTouch2.getFont() != null) {
            padTouch2.setFont(padTouch2.getFont().deriveFont((float) 14));
        }
        padTouch2.setForeground(new Color(0, 0, 255));
        padTouch2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch2"));
        padTouch2.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch2"));
        padTouch2.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch2"));
    }

    protected void createPadTouch3() {
        $objectMap.put("padTouch3", padTouch3 = new JButton());
        
        padTouch3.setName("padTouch3");
        padTouch3.setFocusable(false);
        padTouch3.setText(t("numbereditor.3"));
        padTouch3.setFocusPainted(false);
        if (padTouch3.getFont() != null) {
            padTouch3.setFont(padTouch3.getFont().deriveFont((float) 14));
        }
        padTouch3.setForeground(new Color(0, 0, 255));
        padTouch3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch3"));
        padTouch3.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch3"));
        padTouch3.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch3"));
    }

    protected void createPadTouch4() {
        $objectMap.put("padTouch4", padTouch4 = new JButton());
        
        padTouch4.setName("padTouch4");
        padTouch4.setFocusable(false);
        padTouch4.setText(t("numbereditor.4"));
        padTouch4.setFocusPainted(false);
        if (padTouch4.getFont() != null) {
            padTouch4.setFont(padTouch4.getFont().deriveFont((float) 14));
        }
        padTouch4.setForeground(new Color(0, 0, 255));
        padTouch4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch4"));
        padTouch4.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch4"));
        padTouch4.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch4"));
    }

    protected void createPadTouch5() {
        $objectMap.put("padTouch5", padTouch5 = new JButton());
        
        padTouch5.setName("padTouch5");
        padTouch5.setFocusable(false);
        padTouch5.setText(t("numbereditor.5"));
        padTouch5.setFocusPainted(false);
        if (padTouch5.getFont() != null) {
            padTouch5.setFont(padTouch5.getFont().deriveFont((float) 14));
        }
        padTouch5.setForeground(new Color(0, 0, 255));
        padTouch5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch5"));
        padTouch5.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch5"));
        padTouch5.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch5"));
    }

    protected void createPadTouch6() {
        $objectMap.put("padTouch6", padTouch6 = new JButton());
        
        padTouch6.setName("padTouch6");
        padTouch6.setFocusable(false);
        padTouch6.setText(t("numbereditor.6"));
        padTouch6.setFocusPainted(false);
        if (padTouch6.getFont() != null) {
            padTouch6.setFont(padTouch6.getFont().deriveFont((float) 14));
        }
        padTouch6.setForeground(new Color(0, 0, 255));
        padTouch6.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch6"));
        padTouch6.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch6"));
        padTouch6.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch6"));
    }

    protected void createPadTouch7() {
        $objectMap.put("padTouch7", padTouch7 = new JButton());
        
        padTouch7.setName("padTouch7");
        padTouch7.setFocusable(false);
        padTouch7.setText(t("numbereditor.7"));
        padTouch7.setFocusPainted(false);
        if (padTouch7.getFont() != null) {
            padTouch7.setFont(padTouch7.getFont().deriveFont((float) 14));
        }
        padTouch7.setForeground(new Color(0, 0, 255));
        padTouch7.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch7"));
        padTouch7.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch7"));
        padTouch7.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch7"));
    }

    protected void createPadTouch8() {
        $objectMap.put("padTouch8", padTouch8 = new JButton());
        
        padTouch8.setName("padTouch8");
        padTouch8.setFocusable(false);
        padTouch8.setText(t("numbereditor.8"));
        padTouch8.setFocusPainted(false);
        if (padTouch8.getFont() != null) {
            padTouch8.setFont(padTouch8.getFont().deriveFont((float) 14));
        }
        padTouch8.setForeground(new Color(0, 0, 255));
        padTouch8.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch8"));
        padTouch8.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch8"));
        padTouch8.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch8"));
    }

    protected void createPadTouch9() {
        $objectMap.put("padTouch9", padTouch9 = new JButton());
        
        padTouch9.setName("padTouch9");
        padTouch9.setFocusable(false);
        padTouch9.setText(t("numbereditor.9"));
        padTouch9.setFocusPainted(false);
        if (padTouch9.getFont() != null) {
            padTouch9.setFont(padTouch9.getFont().deriveFont((float) 14));
        }
        padTouch9.setForeground(new Color(0, 0, 255));
        padTouch9.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouch9"));
        padTouch9.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouch9"));
        padTouch9.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouch9"));
    }

    protected void createPadTouchClearAll() {
        $objectMap.put("padTouchClearAll", padTouchClearAll = new JButton());
        
        padTouchClearAll.setName("padTouchClearAll");
        padTouchClearAll.setFocusable(false);
        padTouchClearAll.setText(t("numbereditor.cleanAll"));
        padTouchClearAll.setFocusPainted(false);
        if (padTouchClearAll.getFont() != null) {
            padTouchClearAll.setFont(padTouchClearAll.getFont().deriveFont((float) 14));
        }
        padTouchClearAll.setForeground(new Color(255, 0, 0));
        padTouchClearAll.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouchClearAll"));
        padTouchClearAll.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouchClearAll"));
        padTouchClearAll.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouchClearAll"));
    }

    protected void createPadTouchClearOne() {
        $objectMap.put("padTouchClearOne", padTouchClearOne = new JButton());
        
        padTouchClearOne.setName("padTouchClearOne");
        padTouchClearOne.setFocusable(false);
        padTouchClearOne.setText(t("numbereditor.cleanOne"));
        padTouchClearOne.setFocusPainted(false);
        if (padTouchClearOne.getFont() != null) {
            padTouchClearOne.setFont(padTouchClearOne.getFont().deriveFont((float) 14));
        }
        padTouchClearOne.setForeground(new Color(255, 0, 0));
        padTouchClearOne.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouchClearOne"));
        padTouchClearOne.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouchClearOne"));
        padTouchClearOne.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouchClearOne"));
    }

    protected void createPadTouchDot() {
        $objectMap.put("padTouchDot", padTouchDot = new JButton());
        
        padTouchDot.setName("padTouchDot");
        padTouchDot.setFocusable(false);
        padTouchDot.setText(t("numbereditor.dot"));
        padTouchDot.setFocusPainted(false);
        if (padTouchDot.getFont() != null) {
            padTouchDot.setFont(padTouchDot.getFont().deriveFont((float) 14));
        }
        padTouchDot.setForeground(new Color(0, 153, 0));
        padTouchDot.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouchDot"));
        padTouchDot.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouchDot"));
        padTouchDot.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouchDot"));
    }

    protected void createPadTouchSign() {
        $objectMap.put("padTouchSign", padTouchSign = new JButton());
        
        padTouchSign.setName("padTouchSign");
        padTouchSign.setFocusable(false);
        padTouchSign.setText(t("numbereditor.sign"));
        padTouchSign.setFocusPainted(false);
        if (padTouchSign.getFont() != null) {
            padTouchSign.setFont(padTouchSign.getFont().deriveFont((float) 14));
        }
        padTouchSign.setForeground(new Color(0, 153, 0));
        padTouchSign.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padTouchSign"));
        padTouchSign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padTouchSign"));
        padTouchSign.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padTouchSign"));
    }

    protected void createPadValidate() {
        $objectMap.put("padValidate", padValidate = new JButton());
        
        padValidate.setName("padValidate");
        padValidate.setFocusable(false);
        padValidate.setFocusPainted(false);
        if (padValidate.getFont() != null) {
            padValidate.setFont(padValidate.getFont().deriveFont((float) 14));
        }
        padValidate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__padValidate"));
        padValidate.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__padValidate"));
        padValidate.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__padValidate"));
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeVisible", this, "doPopupMenuWillBecomeVisible__on__popup"));
    }

    protected void createPopupPanel() {
        $objectMap.put("popupPanel", popupPanel = new JPanel());
        
        popupPanel.setName("popupPanel");
        popupPanel.setLayout(new GridLayout(4,4));
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setFocusPainted(false);
        if (resetButton.getFont() != null) {
            resetButton.setFont(resetButton.getFont().deriveFont((float) 14));
        }
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
        resetButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__resetButton"));
        resetButton.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__resetButton"));
    }

    protected void createShowPopUpButton() {
        $objectMap.put("showPopUpButton", showPopUpButton = new JToggleButton());
        
        showPopUpButton.setName("showPopUpButton");
        showPopUpButton.setToolTipText(t("numbereditor.action.show.tip"));
        showPopUpButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__showPopUpButton"));
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createShowResetTip() {
        $objectMap.put("showResetTip", showResetTip = new String());
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setFloatable(false);
        toolbarLeft.setOpaque(false);
        toolbarLeft.setBorderPainted(false);
    }

    protected void createToolbarRight() {
        $objectMap.put("toolbarRight", toolbarRight = new JToolBar());
        
        toolbarRight.setName("toolbarRight");
        toolbarRight.setFloatable(false);
        toolbarRight.setOpaque(false);
        toolbarRight.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditorPanel();
        addChildrenToPopup();
        addChildrenToPopupPanel();
        addChildrenToToolbarLeft();
        addChildrenToToolbarRight();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        popupPanel.setBackground(Color.WHITE);
        popupPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        padValidate.setIcon(SwingUtil.createActionIcon("numbereditor-validate"));
        resetButton.setIcon(SwingUtil.createActionIcon("numbereditor-reset"));
        toolbarRight.setMaximumSize(new Dimension(24,24));
        showPopUpButton.setIcon(SwingUtil.createActionIcon("numbereditor-calculator"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("editorPanel", editorPanel);
        createShowReset();
        createShowResetTip();
        createModel();
        createPopup();
        createPopupPanel();
        createPadTouch7();
        createPadTouch8();
        createPadTouch9();
        createPadTouchClearAll();
        createPadTouch4();
        createPadTouch5();
        createPadTouch6();
        createPadTouchClearOne();
        createPadTouch1();
        createPadTouch2();
        createPadTouch3();
        create$JButton0();
        createPadTouch0();
        createPadTouchSign();
        createPadTouchDot();
        createPadValidate();
        createToolbarLeft();
        createResetButton();
        createEditor();
        createToolbarRight();
        createShowPopUpButton();
        // inline creation of editorPanel
        setName("editorPanel");
        setLayout(new BorderLayout());
        editorPanel.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__editorPanel"));
        editorPanel.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__editorPanel"));
        editorPanel.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseExited", this, "doMouseExited__on__editorPanel"));
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PAD_TOUCH_SIGN_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("useSign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    padTouchSign.setEnabled(model.isUseSign());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("useSign", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showReset", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    toolbarLeft.setVisible(model.isShowReset());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showReset", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                resetButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RESET_BUTTON_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showResetTip", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    resetButton.setToolTipText(t(model.getShowResetTip()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showResetTip", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SHOW_POP_UP_BUTTON_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                showPopUpButton.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SHOW_POP_UP_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("showPopup", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    showPopUpButton.setVisible(model.isShowPopup());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("showPopup", this);
                }
            }
        });
    }

}