/*
 * #%L
 * JAXX :: Widgets
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.editor;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.swing.renderer.I18nTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ColumnSelector extends javax.swing.JPanel implements PropertyChangeListener,  ActionListener, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MY_TABLE = "myTable";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_SELECTED = "button.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTU8TQRieVvrJp1QbCBhRCTEmbjkLQQQk0hQl0hhiL067Qxky3RlmZ2HxYPwJ/gS9ezHx5sl48OzBi/EvGOPBq/Gd2bZLYaEN9LDbzDzvM8/77PPO+18o4Up0Yxf7viU9R9EGsYoPtraeVHdJTa0QtyapUFyi4BeLo3gF9dvtdVehW5WSLi80ywvLvCG4Q5wj1XMllHXVISPuDiFKoWudFTXXLWy2t+d84ckWa1tUFOvbP7/jb+zX7+II+QLUpaGVqW5VYSd9JRSntkKjcNI+LjDs1EGGpE4d9A7qtWWGXfcxbpA99AqlSigpsAQyhW723rLhMPW+UCg9XdzADmGzCt3uUOoewLkWsSnUgmzmNZxNwuAbcCmEqU8qlGoclnGVEYVGtDxLS7aCTxWCBgQXnnhGXWqQl0PkEueMYCeEJgxUobzG+E0NxQ29uE4cLwRmDbCEq4SBXx1os6hho210bnrTuLDmUEUxoy+JhH5nTL81sIoyIq3AKOsE8sih08UyKF7CuvpKx6HNdQ3MtPHJqqcUdxQaP4at1xlZMnsaOSEgJhMd5kMArTCAYUJiFZSQHiwrNFY5mdmnsBWkdexYWjWh2f2Xz33/9PPjaiuiQ3D21UjokQmD6AjJBZGK6qOHg3x6irLCOhZzFZRxm9GA3ckIYa3kgDg4L0iALrceYXcHKBKpH5+/5F98u4TiqyjLOLZXscavoYzakeACZ7Yv7i8aRQMHaXiOaG3gMcOHHKxEQ/M2VniqSh0bXF7wwYTJCBPaSqqZr39zmx8WW0bEQNj4qfDQjMRzlKQOow4x09ocxMjp7Bcu8WweDlzUCMb0OyuaKZsxzzuRnVa5tImJ2F3f0y/LyNb/Zg1LrgeWFHH0wOpbZj5oYworuGMgqmQhmjbfA22fIr7Su/fOzzEYNLiBqaOIfQbZZA9kmW1IkdKtXpAoyQXe8y7K0kdrwbCf8umud+XQyytnqOjOADfxNq95bneDe+HKGK4uBvdCNCw5Y3yfyIdBMi9Ilw6uooDn3G4r1K/gSi9TUT472JrqP7abWnu1CAAA";
    protected static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.ColumnSelector.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToggleButton button;
    protected java.lang.Object myTable;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.JLabel popupLabel;
    protected java.lang.Boolean popupVisible;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ColumnSelector $JPanel0 = this;
    private javax.swing.JToolBar $JToolBar0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String TABLE_PROPERTY = "myTable";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        }
        //log.info(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        if (TABLE_PROPERTY.equals(name)) {
            // table has changed, rebuild the popup
            try {
                
                popup.removeAll();
                JTable t = (JTable) evt.getNewValue();
                if (t != null) {
                    log.info("table has changed ! " + t.getName());
                    for (int i = 0, columnCount = t.getColumnCount(); i < columnCount; i++) {
                        TableColumn column = t.getColumnModel().getColumn(i);
                        TableCellRenderer defaultRenderer = t.getTableHeader().getDefaultRenderer();
                        String columnName = column.getHeaderValue() + "";
                        if (defaultRenderer instanceof I18nTableCellRenderer) {
                            I18nTableCellRenderer renderer = (I18nTableCellRenderer) defaultRenderer;
                            columnName = _(renderer.getKeys()[i]);
                        }
                        JRadioButtonMenuItem b = new JRadioButtonMenuItem(columnName, null, true);
                        popup.add(b);
                        b.addActionListener(this);
                        b.putClientProperty("columnIndex", i);
                        b.putClientProperty("columnName", columnName);
                        b.putClientProperty("column", column);
                    }
                }
            } finally {
                popup.invalidate();
            }
            return;
        }
        if (POPUP_VISIBLE_PROPERTY.equals(name)) {
            Boolean newValue = (Boolean) evt.getNewValue();
            if (newValue == null || !newValue) {
                if (getPopup() != null && getPopup().isVisible()) {
                    getPopup().setVisible(false);
                }
                return;
            }
            if (!getPopup().isVisible()) {
                SwingUtilities.invokeLater(showPopupRunnable);
            }
            return;
        }
        
    }
    
    @Override
    public void actionPerformed(ActionEvent event) {
        JRadioButtonMenuItem source = (JRadioButtonMenuItem) event.getSource();
        boolean selected = source.isSelected();
        TableColumn column = (TableColumn) source.getClientProperty("column");
        Integer columnIndex = (Integer) source.getClientProperty("columnIndex");
        String columnName = (String) source.getClientProperty("columnName");
        log.info(columnName + ", selected : " + selected);
        JTable t = (JTable) myTable;
        if (selected) {
            // reinject the column in table
            t.getColumnModel().addColumn(column);
        } else {
            // remove column from table
            t.getColumnModel().removeColumn(column);
        }
    }protected Runnable showPopupRunnable;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ColumnSelector() {
        $initialize();
    }

    public ColumnSelector(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__$JPanel0(java.awt.event.FocusEvent event) {
        button.requestFocus();
    }

    public void doFocusLost__on__$JPanel0(java.awt.event.FocusEvent event) {
        setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(java.awt.event.ItemEvent event) {
        if (event.getStateChange()  == ItemEvent.SELECTED) { setPopupVisible(true); } else { popupVisible = false; };
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JToggleButton getButton() {
        return button;
    }

    public java.lang.Object getMyTable() {
        return myTable;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public java.lang.Boolean getPopupVisible() {
        return popupVisible;
    }

    public java.lang.Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setMyTable(java.lang.Object newValue) {
        java.lang.Object oldValue = this.myTable;
        this.myTable = newValue;
        firePropertyChange(PROPERTY_MY_TABLE, oldValue, newValue);
    }

    public void setPopupVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        firePropertyChange(PROPERTY_POPUP_VISIBLE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupLabel);
    }

    protected void create$ScriptInitializer0() {
        showPopupRunnable = new Runnable() {
            @Override
            public void run() {
                getPopup().pack();
                Dimension dim = getPopup().getPreferredSize();
                JToggleButton invoker = getButton();
                getPopup().show(invoker, (int) (invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
            }
        };
    }

    protected void createButton() {
        $objectMap.put("button", button = new javax.swing.JToggleButton());
        button.setName("button");
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setFocusable(true);
        button.setRolloverEnabled(false);
        button.setToolTipText(_("columnselector.action.tip"));
        button.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__button"));
    }

    protected void createMyTable() {
        $objectMap.put("myTable", myTable = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new javax.swing.JPopupMenu());
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new javax.swing.JLabel());
        popupLabel.setName("popupLabel");
        popupLabel.setEnabled(false);
        popupLabel.setText(_("i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        $objectMap.put("popupVisible", popupVisible = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JPanel0
        add($JToolBar0);
        addChildrenToPopup();
        // inline complete setup of $JToolBar0
        $JToolBar0.add(button, BorderLayout.CENTER);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        popup.setBorder(new TitledBorder(_("i18neditor.popup.title")));
        button.setIcon(jaxx.runtime.SwingUtil.createActionIcon("numbereditor-calculator"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        // registers 1 data bindings
        $registerDefaultBindings();
        $objectMap.put("$JPanel0", this);
        createMyTable();
        createPopupVisible();
        createPopup();
        createPopupLabel();
        create$ScriptInitializer0();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new javax.swing.JToolBar());
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setBorderPainted(false);
        $JToolBar0.setFloatable(false);
        $JToolBar0.setOpaque(false);
        createButton();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$JPanel0"));
        
        addPropertyChangeListener(TABLE_PROPERTY,this);addPropertyChangeListener(POPUP_VISIBLE_PROPERTY,this);$completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (popup != null) {
                    $bindingSources.put("popup", popup);
                    popup.addComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (popup != null) {
                    button.setSelected(popup.isVisible());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (popup != null) {
                    javax.swing.JPopupMenu $target = ((javax.swing.JPopupMenu) $bindingSources.remove("popup"));
                    if ($target != null) {
                        $target.removeComponentListener( JAXXUtil.getEventListener(ComponentListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(java.awt.event.ComponentEvent event) {
                propertyChange(null);
            }
        });
    }

}